/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.engine.liveness.LivenessStateException;
import io.deephaven.util.Utils;
import java.lang.ref.WeakReference;

public interface LivenessReferent {
    default public void retainReference() {
        if (!this.tryRetainReference()) {
            throw new LivenessStateException(this + " is no longer live and cannot be retained further");
        }
    }

    public boolean tryRetainReference();

    public void dropReference();

    public WeakReference<? extends LivenessReferent> getWeakReference();

    default public String getReferentDescription() {
        return Utils.makeReferentDescription((Object)this);
    }
}

