/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.engine.liveness.Liveness;
import io.deephaven.engine.liveness.LivenessManager;
import io.deephaven.engine.liveness.PermanentLivenessManager;
import io.deephaven.engine.liveness.ReferenceCountedLivenessNode;
import io.deephaven.engine.liveness.ReleasableLivenessManager;
import io.deephaven.util.Utils;
import org.jetbrains.annotations.NotNull;

public class LivenessScope
extends ReferenceCountedLivenessNode
implements ReleasableLivenessManager {
    public LivenessScope() {
        this(false);
    }

    public LivenessScope(boolean enforceStrongReachability) {
        super(enforceStrongReachability);
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return;
        }
        if (Liveness.DEBUG_MODE_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: Creating scope ").append(Utils.REFERENT_FORMATTER, (Object)this).endl();
        }
        this.incrementReferenceCount();
    }

    public final void transferTo(@NotNull LivenessManager other) {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return;
        }
        if (this.enforceStrongReachability) {
            throw new UnsupportedOperationException("LivenessScope does not support reference transfer if enforceStrongReachability is specified");
        }
        if (other instanceof ReferenceCountedLivenessNode) {
            this.tracker.transferReferencesTo(((ReferenceCountedLivenessNode)other).tracker);
        } else if (other instanceof PermanentLivenessManager) {
            this.tracker.makeReferencesPermanent();
        } else {
            throw new UnsupportedOperationException("Unable to transfer to unrecognized implementation class=" + Utils.getSimpleNameFor((Object)other) + ", instance=" + other);
        }
    }

    @Override
    public final void release() {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return;
        }
        if (Liveness.DEBUG_MODE_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: Begin releasing scope ").append(Utils.REFERENT_FORMATTER, (Object)this).endl();
        }
        this.decrementReferenceCount();
        if (Liveness.DEBUG_MODE_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: End releasing scope ").append(Utils.REFERENT_FORMATTER, (Object)this).endl();
        }
    }
}

