/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.engine.liveness.Liveness;
import io.deephaven.engine.liveness.LivenessManager;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.liveness.LivenessScope;
import io.deephaven.engine.liveness.PermanentLivenessManager;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.Utils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class LivenessScopeStack {
    private static final ThreadLocal<LivenessScopeStack> THREAD_STACK = ThreadLocal.withInitial(LivenessScopeStack::new);
    private static final ThreadLocal<LivenessManager> THREAD_BASE_MANAGER = ThreadLocal.withInitial(PermanentLivenessManager::new);
    private final Deque<LivenessScope> stack = new ArrayDeque<LivenessScope>();

    private LivenessScopeStack() {
    }

    public static void push(@NotNull LivenessScope scope) {
        THREAD_STACK.get().pushInternal(scope);
    }

    public static void pop(@NotNull LivenessScope scope) {
        THREAD_STACK.get().popInternal(scope);
    }

    @NotNull
    public static LivenessManager peek() {
        return THREAD_STACK.get().peekInternal();
    }

    @NotNull
    public static SafeCloseable open(@NotNull LivenessScope scope, boolean releaseOnClose) {
        LivenessScopeStack.push(scope);
        return releaseOnClose ? new PopAndReleaseOnClose(scope) : new PopOnClose(scope);
    }

    @NotNull
    public static SafeCloseable open() {
        LivenessScope scope = new LivenessScope();
        LivenessScopeStack.push(scope);
        return new PopAndReleaseOnClose(scope);
    }

    private void pushInternal(@NotNull LivenessScope scope) {
        if (Liveness.DEBUG_MODE_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: Pushing scope ").append(Utils.REFERENT_FORMATTER, (Object)scope).endl();
        }
        this.stack.push(scope);
    }

    private void popInternal(@NotNull LivenessScope scope) {
        LivenessScope peeked;
        if (Liveness.DEBUG_MODE_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: Popping scope ").append(Utils.REFERENT_FORMATTER, (Object)scope).endl();
        }
        if ((peeked = this.stack.peekFirst()) != scope) {
            throw new IllegalStateException("Caller requested to pop " + scope + " but the top of the scope stack is " + peeked);
        }
        this.stack.pop();
    }

    @NotNull
    private LivenessManager peekInternal() {
        LivenessScope peeked = this.stack.peekFirst();
        return peeked != null ? peeked : THREAD_BASE_MANAGER.get();
    }

    public static <RESULT_TYPE extends LivenessReferent> RESULT_TYPE computeEnclosed(@NotNull Supplier<RESULT_TYPE> computation, @NotNull BooleanSupplier shouldEnclose, @NotNull Predicate<RESULT_TYPE> shouldManageResult) {
        LivenessManager enclosingLivenessManager = LivenessScopeStack.peek();
        try (SafeCloseable ignored = shouldEnclose.getAsBoolean() ? LivenessScopeStack.open(new LivenessScope(), true) : null;){
            LivenessReferent result = (LivenessReferent)computation.get();
            if (shouldManageResult.test(result)) {
                enclosingLivenessManager.manage(result);
            }
            LivenessReferent livenessReferent = result;
            return (RESULT_TYPE)livenessReferent;
        }
    }

    public static <RESULT_TYPE extends LivenessReferent> RESULT_TYPE[] computeArrayEnclosed(@NotNull Supplier<RESULT_TYPE[]> computation, @NotNull BooleanSupplier shouldEnclose, @NotNull Predicate<RESULT_TYPE> shouldManageResult) {
        LivenessManager enclosingLivenessManager = LivenessScopeStack.peek();
        try (SafeCloseable ignored = shouldEnclose.getAsBoolean() ? LivenessScopeStack.open(new LivenessScope(), true) : null;){
            LivenessReferent[] results;
            for (LivenessReferent result : results = (LivenessReferent[])computation.get()) {
                if (!shouldManageResult.test(result)) continue;
                enclosingLivenessManager.manage(result);
            }
            LivenessReferent[] livenessReferentArray = results;
            return livenessReferentArray;
        }
    }

    private static final class PopAndReleaseOnClose
    implements SafeCloseable {
        private final LivenessScope scope;

        private PopAndReleaseOnClose(@NotNull LivenessScope scope) {
            this.scope = scope;
        }

        public void close() {
            LivenessScopeStack.pop(this.scope);
            this.scope.release();
        }
    }

    private static final class PopOnClose
    implements SafeCloseable {
        private final LivenessScope scope;

        private PopOnClose(@NotNull LivenessScope scope) {
            this.scope = scope;
        }

        public void close() {
            LivenessScopeStack.pop(this.scope);
        }
    }
}

