/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.engine.liveness.Liveness;
import io.deephaven.engine.liveness.LivenessNode;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.liveness.ReferenceCountedLivenessReferent;
import io.deephaven.engine.liveness.RetainedReferenceTracker;
import io.deephaven.util.Utils;
import io.deephaven.util.annotations.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceCountedLivenessNode
extends ReferenceCountedLivenessReferent
implements LivenessNode {
    final boolean enforceStrongReachability;
    transient RetainedReferenceTracker<ReferenceCountedLivenessNode> tracker;

    protected ReferenceCountedLivenessNode(boolean enforceStrongReachability) {
        this.enforceStrongReachability = enforceStrongReachability;
        this.initializeTransientFieldsForLiveness();
    }

    @VisibleForTesting
    public final void initializeTransientFieldsForLiveness() {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return;
        }
        this.tracker = new RetainedReferenceTracker<ReferenceCountedLivenessNode>(this, this.enforceStrongReachability);
        if (Liveness.DEBUG_MODE_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: Created tracker ").append(Utils.REFERENT_FORMATTER, this.tracker).append((CharSequence)" for ").append(Utils.REFERENT_FORMATTER, (Object)this).endl();
        }
    }

    @Override
    public WeakReference<? extends LivenessReferent> getWeakReference() {
        return this.tracker;
    }

    @Override
    public final boolean tryManage(@NotNull LivenessReferent referent) {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return true;
        }
        if (Liveness.DEBUG_MODE_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: ").append((CharSequence)this.getReferentDescription()).append((CharSequence)" managing ").append((CharSequence)referent.getReferentDescription()).endl();
        }
        if (!this.tryRetainReference()) {
            return false;
        }
        try {
            if (!referent.tryRetainReference()) {
                boolean bl = false;
                return bl;
            }
            this.tracker.addReference(referent);
        }
        finally {
            this.dropReference();
        }
        return true;
    }

    @Override
    public final boolean tryUnmanage(@NotNull LivenessReferent referent) {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return true;
        }
        if (!this.tryRetainReference()) {
            return false;
        }
        try {
            this.tracker.dropReference(referent);
        }
        finally {
            this.dropReference();
        }
        return true;
    }

    @Override
    public final boolean tryUnmanage(@NotNull Stream<? extends LivenessReferent> referents) {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return true;
        }
        if (!this.tryRetainReference()) {
            return false;
        }
        try {
            this.tracker.dropReferences(referents);
        }
        finally {
            this.dropReference();
        }
        return true;
    }

    @Override
    public final void onReferenceCountAtZero() {
        super.onReferenceCountAtZero();
        this.tracker.ensureReferencesDropped();
    }
}

