/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.engine.liveness.Liveness;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.liveness.LivenessStateException;
import io.deephaven.util.Utils;
import io.deephaven.util.referencecounting.ReferenceCounted;
import java.lang.ref.WeakReference;

public class ReferenceCountedLivenessReferent
extends ReferenceCounted
implements LivenessReferent {
    @Override
    public final boolean tryRetainReference() {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return true;
        }
        return this.tryIncrementReferenceCount();
    }

    @Override
    public final void dropReference() {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return;
        }
        if (Liveness.DEBUG_MODE_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: Releasing ").append(Utils.REFERENT_FORMATTER, (Object)this).endl();
        }
        if (!this.tryDecrementReferenceCount()) {
            throw new LivenessStateException(this.getReferentDescription() + " could not be released as it was no longer live");
        }
    }

    @Override
    public WeakReference<? extends LivenessReferent> getWeakReference() {
        return new WeakReference<ReferenceCountedLivenessReferent>(this);
    }

    protected void destroy() {
    }

    protected void onReferenceCountAtZero() {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            throw new IllegalStateException("Reference count on " + this + " reached zero while liveness reference tracking is disabled");
        }
        try {
            this.destroy();
        }
        catch (Exception e) {
            Liveness.log.warn().append((CharSequence)"Exception while destroying ").append(Utils.REFERENT_FORMATTER, (Object)this).append((CharSequence)" after reference count reached zero: ").append((Throwable)e).endl();
        }
    }
}

