/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.base.cache.RetentionCache;
import io.deephaven.base.reference.CleanupReference;
import io.deephaven.base.reference.WeakCleanupReference;
import io.deephaven.engine.liveness.Liveness;
import io.deephaven.engine.liveness.LivenessDebugException;
import io.deephaven.engine.liveness.LivenessManager;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.liveness.LivenessStateException;
import io.deephaven.engine.util.reference.CleanupReferenceProcessorInstance;
import io.deephaven.hash.KeyedObjectHashMap;
import io.deephaven.hash.KeyedObjectKey;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.Utils;
import io.deephaven.util.datastructures.hash.KeyIdentityKeyedObjectKey;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class RetainedReferenceTracker<TYPE extends LivenessManager>
extends WeakCleanupReference<TYPE> {
    private static final AtomicIntegerFieldUpdater<RetainedReferenceTracker> OUTSTANDING_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RetainedReferenceTracker.class, "outstandingState");
    private static final int NOT_OUTSTANDING = 0;
    private static final int OUTSTANDING = 1;
    private static final AtomicInteger outstandingCount = new AtomicInteger(0);
    private static final ThreadLocal<Queue<WeakReference<? extends LivenessReferent>>> tlPendingDropReferences = new ThreadLocal();
    private static final ThreadLocal<SoftReference<Queue<WeakReference<? extends LivenessReferent>>>> tlSavedQueueReference = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(RetainedReferenceTracker.class);
    private final Impl impl;
    private volatile int outstandingState = 1;

    RetainedReferenceTracker(@NotNull TYPE manager, boolean enforceStrongReachability) {
        super(manager, CleanupReferenceProcessorInstance.LIVENESS.getReferenceQueue());
        this.impl = enforceStrongReachability ? new StrongImpl() : new WeakImpl();
        outstandingCount.getAndIncrement();
        if (Liveness.DEBUG_MODE_ENABLED) {
            log.info().append((CharSequence)"Creating ").append(Utils.REFERENT_FORMATTER, (Object)this).append((CharSequence)" at ").append((Throwable)new LivenessDebugException()).endl();
        }
    }

    public String toString() {
        return Utils.makeReferentDescription((Object)((Object)this));
    }

    synchronized void addReference(@NotNull LivenessReferent referent) throws LivenessStateException {
        this.checkOutstanding();
        this.impl.add(referent);
    }

    synchronized void dropReference(@NotNull LivenessReferent referent) throws LivenessStateException {
        this.checkOutstanding();
        this.impl.drop(referent);
    }

    synchronized void dropReferences(@NotNull Stream<? extends LivenessReferent> referents) throws LivenessStateException {
        this.checkOutstanding();
        this.impl.drop(referents);
    }

    synchronized void transferReferencesTo(@NotNull RetainedReferenceTracker<?> other) {
        this.checkOutstanding();
        for (WeakReference retainedReference : this.impl) {
            LivenessReferent retained = (LivenessReferent)retainedReference.get();
            if (retained != null) {
                other.addReference(retained);
                continue;
            }
            if (!(retainedReference instanceof CleanupReference)) continue;
            ((CleanupReference)retainedReference).cleanup();
        }
        this.impl.clear();
    }

    synchronized void makeReferencesPermanent() {
        this.checkOutstanding();
        this.impl.makePermanent();
    }

    private void checkOutstanding() {
        if (this.outstandingState == 0) {
            throw new LivenessStateException("RetainedReferenceTracker " + this + " has already performed cleanup for manager " + this.get());
        }
    }

    public void cleanup() {
        this.ensureReferencesDroppedInternal(true);
    }

    void ensureReferencesDropped() {
        this.ensureReferencesDroppedInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureReferencesDroppedInternal(boolean onCleanup) {
        Object savedQueueReference;
        boolean processDrops;
        if (!OUTSTANDING_STATE_UPDATER.compareAndSet(this, 1, 0)) {
            return;
        }
        if (Liveness.DEBUG_MODE_ENABLED || onCleanup && Liveness.CLEANUP_LOG_ENABLED) {
            Liveness.log.info().append((CharSequence)"LivenessDebug: Ensuring references dropped ").append((CharSequence)(onCleanup ? "(on cleanup) " : "")).append((CharSequence)"for ").append(Utils.REFERENT_FORMATTER, (Object)this).endl();
        }
        outstandingCount.decrementAndGet();
        ArrayDeque pendingDropReferences = tlPendingDropReferences.get();
        boolean bl = processDrops = pendingDropReferences == null;
        if (processDrops) {
            savedQueueReference = tlSavedQueueReference.get();
            if (savedQueueReference == null || (pendingDropReferences = (ArrayDeque)((SoftReference)savedQueueReference).get()) == null) {
                pendingDropReferences = new ArrayDeque();
                tlSavedQueueReference.set(new SoftReference(pendingDropReferences));
            }
            tlPendingDropReferences.set(pendingDropReferences);
        }
        savedQueueReference = this;
        synchronized (savedQueueReference) {
            this.impl.forEach(pendingDropReferences::add);
            this.impl.clear();
        }
        if (processDrops) {
            try {
                WeakReference pendingDropReference;
                while ((pendingDropReference = (WeakReference)pendingDropReferences.poll()) != null) {
                    LivenessReferent pendingDrop = (LivenessReferent)pendingDropReference.get();
                    if (pendingDrop != null) {
                        pendingDrop.dropReference();
                        continue;
                    }
                    if (!(pendingDropReference instanceof CleanupReference)) continue;
                    ((CleanupReference)pendingDropReference).cleanup();
                }
            }
            finally {
                tlPendingDropReferences.set(null);
            }
        }
    }

    static int getOutstandingCount() {
        return outstandingCount.get();
    }

    private static final class DropState {
        private static final KeyedObjectKey<LivenessReferent, DropState> KEYED_OBJECT_KEY = new KeyIdentityKeyedObjectKey<LivenessReferent, DropState>(){

            public LivenessReferent getKey(@NotNull DropState dropState) {
                return dropState.referent;
            }
        };
        private final LivenessReferent referent;
        private int timesToDrop;

        private DropState(@NotNull LivenessReferent referent) {
            this.referent = referent;
        }

        void incrementDrops() {
            ++this.timesToDrop;
        }

        boolean doDrop() {
            this.referent.dropReference();
            return --this.timesToDrop == 0;
        }
    }

    private static final class StrongImpl
    implements Impl {
        private static final RetentionCache<LivenessReferent> permanentReferences = new RetentionCache();
        private final List<LivenessReferent> retained = new ArrayList<LivenessReferent>();

        private StrongImpl() {
        }

        @Override
        public void add(@NotNull LivenessReferent referent) {
            this.retained.add(referent);
        }

        @Override
        public void drop(@NotNull LivenessReferent referent) {
            int rLast = this.retained.size() - 1;
            for (int ri = 0; ri <= rLast; ++ri) {
                LivenessReferent current = this.retained.get(ri);
                if (current != referent) continue;
                if (ri != rLast) {
                    this.retained.set(ri, this.retained.get(rLast));
                }
                this.retained.remove(rLast);
                current.dropReference();
                return;
            }
        }

        @Override
        public void drop(@NotNull Stream<? extends LivenessReferent> referents) {
            KeyedObjectHashMap referentsToRemove = new KeyedObjectHashMap(DropState.KEYED_OBJECT_KEY);
            referents.forEach(referent -> ((DropState)referentsToRemove.putIfAbsent(referent, x$0 -> new DropState((LivenessReferent)x$0))).incrementDrops());
            if (referentsToRemove.isEmpty()) {
                return;
            }
            int rLast = this.retained.size() - 1;
            int ri = 0;
            while (ri <= rLast) {
                LivenessReferent current = this.retained.get(ri);
                DropState foundState = (DropState)referentsToRemove.get((Object)current);
                if (foundState != null) {
                    if (ri != rLast) {
                        this.retained.set(ri, this.retained.get(rLast));
                    }
                    this.retained.remove(rLast--);
                    if (!foundState.doDrop()) continue;
                    referentsToRemove.remove((Object)current);
                    if (!referentsToRemove.isEmpty()) continue;
                    return;
                }
                ++ri;
            }
        }

        @Override
        public void clear() {
            this.retained.clear();
        }

        @Override
        public void makePermanent() {
            this.retained.forEach(arg_0 -> permanentReferences.retain(arg_0));
            this.retained.clear();
        }

        @Override
        @NotNull
        public Iterator<WeakReference<? extends LivenessReferent>> iterator() {
            return new Iterator<WeakReference<? extends LivenessReferent>>(){
                private final Iterator<LivenessReferent> internal;
                {
                    this.internal = retained.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.internal.hasNext();
                }

                @Override
                public WeakReference<? extends LivenessReferent> next() {
                    return this.internal.next().getWeakReference();
                }
            };
        }
    }

    private static final class WeakImpl
    implements Impl {
        private final List<WeakReference<? extends LivenessReferent>> retainedReferences = new ArrayList<WeakReference<? extends LivenessReferent>>();

        private WeakImpl() {
        }

        @Override
        public void add(@NotNull LivenessReferent referent) {
            this.retainedReferences.add(referent.getWeakReference());
        }

        @Override
        public void drop(@NotNull LivenessReferent referent) {
            int rrLast = this.retainedReferences.size() - 1;
            int rri = 0;
            while (rri <= rrLast) {
                boolean found;
                WeakReference<? extends LivenessReferent> retainedReference = this.retainedReferences.get(rri);
                LivenessReferent retained = (LivenessReferent)retainedReference.get();
                boolean cleared = retained == null;
                boolean bl = found = !cleared && retained == referent;
                if (!cleared && !found) {
                    ++rri;
                    continue;
                }
                if (rri != rrLast) {
                    this.retainedReferences.set(rri, this.retainedReferences.get(rrLast));
                }
                this.retainedReferences.remove(rrLast--);
                if (cleared && retainedReference instanceof CleanupReference) {
                    ((CleanupReference)retainedReference).cleanup();
                }
                if (!found) continue;
                referent.dropReference();
                return;
            }
        }

        @Override
        public void drop(@NotNull Stream<? extends LivenessReferent> referents) {
            KeyedObjectHashMap referentsToRemove = new KeyedObjectHashMap(DropState.KEYED_OBJECT_KEY);
            referents.forEach(referent -> ((DropState)referentsToRemove.putIfAbsent(referent, x$0 -> new DropState((LivenessReferent)x$0))).incrementDrops());
            if (referentsToRemove.isEmpty()) {
                return;
            }
            int rrLast = this.retainedReferences.size() - 1;
            int rri = 0;
            while (rri <= rrLast) {
                DropState foundState;
                WeakReference<? extends LivenessReferent> retainedReference = this.retainedReferences.get(rri);
                LivenessReferent retained = (LivenessReferent)retainedReference.get();
                boolean cleared = retained == null;
                DropState dropState = foundState = cleared ? null : (DropState)referentsToRemove.get((Object)retained);
                if (!cleared && foundState == null) {
                    ++rri;
                    continue;
                }
                if (rri != rrLast) {
                    this.retainedReferences.set(rri, this.retainedReferences.get(rrLast));
                }
                this.retainedReferences.remove(rrLast--);
                if (cleared && retainedReference instanceof CleanupReference) {
                    ((CleanupReference)retainedReference).cleanup();
                }
                if (foundState == null || !foundState.doDrop()) continue;
                referentsToRemove.remove((Object)foundState.referent);
                if (!referentsToRemove.isEmpty()) continue;
                return;
            }
        }

        @Override
        public void clear() {
            this.retainedReferences.clear();
        }

        @Override
        public void makePermanent() {
            this.retainedReferences.clear();
        }

        @Override
        @NotNull
        public Iterator<WeakReference<? extends LivenessReferent>> iterator() {
            return this.retainedReferences.iterator();
        }
    }

    private static interface Impl
    extends Iterable<WeakReference<? extends LivenessReferent>> {
        public void add(@NotNull LivenessReferent var1);

        public void drop(@NotNull LivenessReferent var1);

        public void drop(@NotNull Stream<? extends LivenessReferent> var1);

        public void clear();

        public void makePermanent();
    }
}

