/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.liveness;

import io.deephaven.base.reference.CleanupReference;
import io.deephaven.engine.liveness.Liveness;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.liveness.ReleasableLivenessManager;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.NotNull;

public class SingletonLivenessManager
implements ReleasableLivenessManager {
    private static final AtomicReferenceFieldUpdater<SingletonLivenessManager, WeakReference> RETAINED_REFERENCE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingletonLivenessManager.class, WeakReference.class, "retainedReference");
    private volatile WeakReference<? extends LivenessReferent> retainedReference;

    public SingletonLivenessManager() {
    }

    public SingletonLivenessManager(@NotNull LivenessReferent referent) {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return;
        }
        referent.retainReference();
        this.initializeRetainedReference(referent.getWeakReference());
    }

    private void initializeRetainedReference(@NotNull WeakReference<? extends LivenessReferent> retainedReference) {
        this.retainedReference = retainedReference;
    }

    private boolean setRetainedReference(@NotNull WeakReference<? extends LivenessReferent> retainedReference) {
        return RETAINED_REFERENCE_UPDATER.compareAndSet(this, null, retainedReference);
    }

    private WeakReference<? extends LivenessReferent> getAndClearRetainedReference() {
        return RETAINED_REFERENCE_UPDATER.getAndSet(this, null);
    }

    @Override
    public final boolean tryManage(@NotNull LivenessReferent referent) {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return true;
        }
        if (!referent.tryRetainReference()) {
            return false;
        }
        if (!this.setRetainedReference(referent.getWeakReference())) {
            referent.dropReference();
            throw new UnsupportedOperationException("SingletonLivenessManager can only manage one referent");
        }
        return true;
    }

    @Override
    public final void release() {
        if (Liveness.REFERENCE_TRACKING_DISABLED) {
            return;
        }
        WeakReference<? extends LivenessReferent> localRetainedReference = this.getAndClearRetainedReference();
        if (localRetainedReference == null) {
            return;
        }
        LivenessReferent retained = (LivenessReferent)localRetainedReference.get();
        if (retained != null) {
            retained.dropReference();
        } else if (localRetainedReference instanceof CleanupReference) {
            ((CleanupReference)localRetainedReference).cleanup();
        }
    }
}

