/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.util.annotations.FinalDefault;

public interface LogicalClock {
    public static final long NULL_CLOCK_VALUE = -1L;
    public static final long STEP_SHIFT = 1L;
    public static final long STATE_MASK = 1L;

    public static long getStep(long value) {
        return value >>> 1;
    }

    public static State getState(long value) {
        return (value & 1L) == 0L ? State.Updating : State.Idle;
    }

    public long currentValue();

    @FinalDefault
    default public long currentStep() {
        return LogicalClock.getStep(this.currentValue());
    }

    @FinalDefault
    default public State currentState() {
        return LogicalClock.getState(this.currentValue());
    }

    public static enum State {
        Updating,
        Idle;

    }
}

