/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.base.verify.Assert;
import io.deephaven.engine.updategraph.LogicalClock;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.annotations.TestUseOnly;
import io.deephaven.util.process.ProcessEnvironment;
import java.util.concurrent.atomic.AtomicLong;

public class LogicalClockImpl
implements LogicalClock {
    private static final Logger log = LoggerFactory.getLogger(LogicalClockImpl.class);
    private static final long INITIAL_CLOCK_VALUE = 5L;
    private final AtomicLong currentValue = new AtomicLong(5L);

    @Override
    public final long currentValue() {
        return this.currentValue.get();
    }

    public final long startUpdateCycle() {
        long beforeValue = this.currentValue.get();
        if (beforeValue == Long.MAX_VALUE) {
            ProcessEnvironment.get().getFatalErrorReporter().report("Maximum logical clock cycles exceeded");
        }
        Assert.eq((Object)((Object)LogicalClock.getState(beforeValue)), (String)"getState(beforeValue)", (Object)((Object)LogicalClock.State.Idle));
        long afterValue = this.currentValue.incrementAndGet();
        Assert.eq((long)afterValue, (String)"currentValue.incrementAndGet()", (long)(beforeValue + 1L), (String)"beforeValue + 1");
        return afterValue;
    }

    public final void completeUpdateCycle() {
        long value = this.currentValue.get();
        Assert.eq((Object)((Object)LogicalClock.getState(value)), (String)"getState(value)", (Object)((Object)LogicalClock.State.Updating));
        Assert.eq((long)this.currentValue.incrementAndGet(), (String)"currentValue.incrementAndGet()", (long)(value + 1L), (String)"value + 1");
    }

    public final void ensureUpdateCycleCompleted(long updatingCycleValue) {
        long value = this.currentValue.get();
        if (value == updatingCycleValue + 1L) {
            return;
        }
        if (value == updatingCycleValue) {
            log.warn().append((CharSequence)"LogicalClockImpl cycle was not completed in normal operation, value=").append(value).endl();
            this.completeUpdateCycle();
            return;
        }
        throw new IllegalStateException("Inconsistent LogicalClockImpl value at end of cycle, expected " + (updatingCycleValue + 1L) + ", encountered " + value);
    }

    @TestUseOnly
    public final void resetForUnitTests() {
        this.currentValue.set(5L);
    }
}

