/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.engine.exceptions.UpdateGraphConflictException;
import io.deephaven.engine.updategraph.DynamicNode;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.util.datastructures.linked.IntrusiveDoublyLinkedNode;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NotificationQueue {
    public void addNotification(@NotNull Notification var1);

    public void addNotifications(@NotNull Collection<? extends Notification> var1);

    public boolean maybeAddNotification(@NotNull Notification var1, long var2);

    public static interface Dependency
    extends LogOutputAppendable {
        public boolean satisfied(long var1);

        public UpdateGraph getUpdateGraph();

        default public UpdateGraph getUpdateGraph(Dependency ... dependencies) {
            return Dependency.getUpdateGraph(this, dependencies);
        }

        public static UpdateGraph getUpdateGraph(@Nullable Dependency first, Dependency ... dependencies) {
            UpdateGraph graph = null;
            UpdateGraph firstNonNullGraph = null;
            if (first != null) {
                firstNonNullGraph = first.getUpdateGraph();
                if (!DynamicNode.isDynamicAndNotRefreshing(first)) {
                    graph = first.getUpdateGraph();
                }
            }
            for (Dependency other : dependencies) {
                if (other != null && firstNonNullGraph == null) {
                    firstNonNullGraph = other.getUpdateGraph();
                }
                if (other == null || DynamicNode.isDynamicAndNotRefreshing(other)) continue;
                if (graph == null) {
                    graph = other.getUpdateGraph();
                    continue;
                }
                if (graph == other.getUpdateGraph()) continue;
                throw new UpdateGraphConflictException("Multiple update graphs found in dependencies: " + graph + " and " + other.getUpdateGraph());
            }
            return graph == null ? firstNonNullGraph : graph;
        }
    }

    public static interface ErrorNotification
    extends Notification {
    }

    public static interface Notification
    extends Runnable,
    LogOutputAppendable,
    IntrusiveDoublyLinkedNode<Notification> {
        public boolean isTerminal();

        public boolean mustExecuteWithUpdateGraphLock();

        public boolean canExecute(long var1);
    }
}

