/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.base.log.LogOutput;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class OneShotUpdateCombiner
implements Runnable,
UpdateSourceRegistrar {
    private final Queue<Runnable> sources = new ArrayDeque<Runnable>();
    private final UpdateGraph updateGraph;

    public OneShotUpdateCombiner(UpdateGraph updateGraph) {
        this.updateGraph = updateGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Runnable oneShot;
            Queue<Runnable> queue = this.sources;
            synchronized (queue) {
                oneShot = this.sources.poll();
            }
            if (oneShot == null) {
                return;
            }
            oneShot.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSource(@NotNull Runnable updateSource) {
        Queue<Runnable> queue = this.sources;
        synchronized (queue) {
            this.sources.add(updateSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSource(@NotNull Runnable updateSource) {
        Queue<Runnable> queue = this.sources;
        synchronized (queue) {
            this.sources.remove(updateSource);
        }
    }

    @Override
    public void requestRefresh() {
        this.updateGraph.requestRefresh();
    }

    @Override
    public boolean satisfied(long step) {
        return this.updateGraph.satisfied(step);
    }

    @Override
    public UpdateGraph getUpdateGraph() {
        return this.updateGraph;
    }

    public LogOutput append(@NotNull LogOutput logOutput) {
        return logOutput.append((CharSequence)"OneShotUpdateCombiner-").append(this.hashCode());
    }
}

