/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.engine.updategraph.TerminalNotification;
import io.deephaven.engine.updategraph.UpdateGraph;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;

public class UpdateCommitter<T>
extends TerminalNotification {
    private final WeakReference<T> targetReference;
    private final Consumer<T> committer;
    private final UpdateGraph updateGraph;
    private boolean active;

    public UpdateCommitter(T target, UpdateGraph updateGraph, Consumer<T> committer) {
        this.targetReference = new WeakReference<T>(target);
        this.updateGraph = updateGraph;
        this.committer = committer;
        this.active = false;
    }

    @Override
    public void run() {
        this.active = false;
        Object target = this.targetReference.get();
        if (target != null) {
            this.committer.accept(target);
        }
    }

    public void maybeActivate() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.updateGraph.addNotification(this);
    }
}

