/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.engine.updategraph.TerminalNotification;
import io.deephaven.engine.updategraph.UpdateGraph;
import java.lang.ref.WeakReference;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class UpdateCommitterEx<T, U>
extends TerminalNotification {
    private final WeakReference<T> targetReference;
    private final UpdateGraph updateGraph;
    private final BiConsumer<T, U> committer;
    private WeakReference<U> secondaryReference;
    private boolean active;

    public UpdateCommitterEx(T target, UpdateGraph updateGraph, BiConsumer<T, U> committer) {
        this.targetReference = new WeakReference<T>(target);
        this.updateGraph = updateGraph;
        this.committer = committer;
    }

    @Override
    public void run() {
        this.active = false;
        Object target = this.targetReference.get();
        Object secondary = this.secondaryReference.get();
        if (target != null && secondary != null) {
            this.committer.accept(target, secondary);
        }
    }

    public void maybeActivate(@NotNull U secondary) {
        if (this.active) {
            return;
        }
        this.active = true;
        if (this.secondaryReference == null || this.secondaryReference.get() != secondary) {
            this.secondaryReference = new WeakReference<U>(secondary);
        }
        this.updateGraph.addNotification(this);
    }
}

