/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.updategraph.LogicalClock;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.engine.updategraph.TerminalNotification;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import io.deephaven.io.log.LogEntry;
import io.deephaven.util.function.ThrowingSupplier;
import io.deephaven.util.locks.AwareFunctionalLock;
import java.util.concurrent.locks.Condition;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface UpdateGraph
extends UpdateSourceRegistrar,
NotificationQueue,
NotificationQueue.Dependency {
    public String getName();

    public AwareFunctionalLock sharedLock();

    public AwareFunctionalLock exclusiveLock();

    public LogicalClock clock();

    public int parallelismFactor();

    default public <UG_TYPE extends UpdateGraph> UG_TYPE cast() {
        return (UG_TYPE)this;
    }

    public LogEntry logDependencies();

    public boolean currentThreadProcessesUpdates();

    public boolean serialTableOperationsSafe();

    public boolean setSerialTableOperationsSafe(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <RETURN_TYPE> RETURN_TYPE allowSerialTableOperations(@NotNull Supplier<RETURN_TYPE> operation) {
        boolean oldValue = this.setSerialTableOperationsSafe(true);
        try {
            RETURN_TYPE RETURN_TYPE = operation.get();
            return RETURN_TYPE;
        }
        finally {
            this.setSerialTableOperationsSafe(oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <RETURN_TYPE, EXCEPTION_TYPE extends Exception> RETURN_TYPE allowSerialTableOperations(@NotNull ThrowingSupplier<RETURN_TYPE, EXCEPTION_TYPE> operation) throws EXCEPTION_TYPE {
        boolean oldValue = this.setSerialTableOperationsSafe(true);
        try {
            Object object = operation.get();
            return (RETURN_TYPE)object;
        }
        finally {
            this.setSerialTableOperationsSafe(oldValue);
        }
    }

    default public void checkInitiateSerialTableOperation() {
        if (this.serialTableOperationsSafe() || this.exclusiveLock().isHeldByCurrentThread() || this.sharedLock().isHeldByCurrentThread() || this.currentThreadProcessesUpdates()) {
            return;
        }
        throw new IllegalStateException(String.format("May not initiate serial table operations for update graph %s: exclusiveLockHeld=%s, sharedLockHeld=%s, currentThreadProcessesUpdates=%s", this.getName(), this.exclusiveLock().isHeldByCurrentThread(), this.sharedLock().isHeldByCurrentThread(), this.currentThreadProcessesUpdates()));
    }

    public void stop();

    public boolean supportsRefreshing();

    @Override
    public void requestRefresh();

    default public void requestSignal(final Condition exclusiveLockCondition) {
        if (this.exclusiveLock().isHeldByCurrentThread()) {
            exclusiveLockCondition.signalAll();
        } else {
            TerminalNotification terminalNotification = new TerminalNotification(){

                @Override
                public void run() {
                    Assert.assertion((boolean)UpdateGraph.this.exclusiveLock().isHeldByCurrentThread(), (String)"exclusiveLock().isHeldByCurrentThread()");
                    exclusiveLockCondition.signalAll();
                }

                @Override
                public boolean mustExecuteWithUpdateGraphLock() {
                    return true;
                }

                @Override
                public LogOutput append(LogOutput output) {
                    return output.append((CharSequence)"SignalNotification(").append(System.identityHashCode(exclusiveLockCondition)).append((CharSequence)")");
                }
            };
            this.addNotification(terminalNotification);
        }
    }
}

