/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.function.ThrowingSupplier;
import io.deephaven.util.locks.FunctionalLock;
import io.deephaven.util.locks.FunctionalReentrantLock;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateGraphAwareCompletableFuture<T>
implements Future<T> {
    private final UpdateGraph updateGraph;
    private volatile Condition updateGraphCondition;
    private final FunctionalLock lock = new FunctionalReentrantLock();
    private volatile Condition lockCondition;
    private volatile ThrowingSupplier<T, ExecutionException> resultSupplier;
    private static final AtomicReferenceFieldUpdater<UpdateGraphAwareCompletableFuture, ThrowingSupplier> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(UpdateGraphAwareCompletableFuture.class, ThrowingSupplier.class, "resultSupplier");
    private static final ThrowingSupplier<?, ExecutionException> CANCELLATION_SUPPLIER = () -> {
        throw new CancellationException();
    };

    public UpdateGraphAwareCompletableFuture(@NotNull UpdateGraph updateGraph) {
        this.updateGraph = updateGraph;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.trySignalCompletion(CANCELLATION_SUPPLIER);
    }

    @Override
    public boolean isCancelled() {
        return this.resultSupplier == CANCELLATION_SUPPLIER;
    }

    @Override
    public boolean isDone() {
        return this.resultSupplier != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.checkSharedLockState();
        if (this.resultSupplier != null) {
            return (T)this.resultSupplier.get();
        }
        try {
            return this.getInternal(0L, null);
        }
        catch (TimeoutException toe) {
            throw new IllegalStateException("Unexpected TimeoutException", toe);
        }
    }

    @Override
    public T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkSharedLockState();
        if (this.resultSupplier != null) {
            return (T)this.resultSupplier.get();
        }
        if (timeout <= 0L) {
            throw new TimeoutException();
        }
        return this.getInternal(timeout, unit);
    }

    private T getInternal(long timeout, @Nullable TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        SafeCloseable ignored;
        boolean holdingUpdateGraphLock = this.updateGraph.exclusiveLock().isHeldByCurrentThread();
        if (holdingUpdateGraphLock) {
            if (this.updateGraphCondition == null) {
                this.updateGraphCondition = this.updateGraph.exclusiveLock().newCondition();
            }
        } else if (this.lockCondition == null) {
            ignored = this.lock.lockCloseable();
            try {
                if (this.lockCondition == null) {
                    this.lockCondition = this.lock.newCondition();
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        if (holdingUpdateGraphLock) {
            this.waitForResult(this.updateGraphCondition, timeout, unit);
        } else {
            ignored = this.lock.lockCloseable();
            try {
                this.waitForResult(this.lockCondition, timeout, unit);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        return (T)this.resultSupplier.get();
    }

    private void checkSharedLockState() {
        if (this.updateGraph.sharedLock().isHeldByCurrentThread()) {
            throw new UnsupportedOperationException("Cannot Future.get(...) while holding the " + this.updateGraph + " shared lock");
        }
    }

    private void waitForResult(Condition condition, long timeout, @Nullable TimeUnit unit) throws InterruptedException, TimeoutException {
        if (unit == null) {
            while (this.resultSupplier == null) {
                condition.await();
            }
            return;
        }
        long nanosLeft = unit.toNanos(timeout);
        while (this.resultSupplier == null) {
            if ((nanosLeft = condition.awaitNanos(nanosLeft)) > 0L) continue;
            throw new TimeoutException();
        }
    }

    public boolean complete(T value) {
        return this.trySignalCompletion(() -> value);
    }

    public boolean completeExceptionally(Throwable ex) {
        Objects.requireNonNull(ex);
        return this.trySignalCompletion(() -> {
            throw new ExecutionException(ex);
        });
    }

    private boolean trySignalCompletion(@NotNull ThrowingSupplier<T, ExecutionException> result) {
        Condition localLockCondition;
        if (!RESULT_UPDATER.compareAndSet(this, null, result)) {
            return false;
        }
        Condition localUpdateGraphCondition = this.updateGraphCondition;
        if (localUpdateGraphCondition != null) {
            this.updateGraph.requestSignal(localUpdateGraphCondition);
        }
        if ((localLockCondition = this.lockCondition) != null) {
            this.lock.doLocked(localLockCondition::signalAll);
        }
        return true;
    }
}

