/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.verify.Assert;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.updategraph.LogicalClock;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.MultiException;
import io.deephaven.util.annotations.TestUseOnly;
import io.deephaven.util.datastructures.linked.IntrusiveDoublyLinkedNode;
import io.deephaven.util.datastructures.linked.IntrusiveDoublyLinkedQueue;
import io.deephaven.util.function.ThrowingRunnable;
import io.deephaven.util.locks.AwareFunctionalLock;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UpdateGraphLock {
    private static final Logger log = LoggerFactory.getLogger(UpdateGraphLock.class);
    private static final boolean STACK_DUMP_LOCKS = Configuration.getInstance().getBooleanWithDefault("UpdateGraphLock.stackDumpLocks", false);
    private static Instrumentation instrumentation = new Instrumentation(){};
    protected final UpdateGraph updateGraph;

    public static void installInstrumentation(@Nullable Instrumentation instrumentation) {
        UpdateGraphLock.instrumentation = instrumentation == null ? new Instrumentation(){} : instrumentation;
    }

    public static UpdateGraphLock create(@NotNull UpdateGraph updateGraph, boolean allowUnitTestMode) {
        return allowUnitTestMode ? new ResettableUpdateGraphLock(updateGraph) : new FinalUpdateGraphLock(updateGraph);
    }

    UpdateGraphLock(@NotNull UpdateGraph updateGraph) {
        this.updateGraph = updateGraph;
    }

    public abstract AwareFunctionalLock sharedLock();

    public abstract AwareFunctionalLock exclusiveLock();

    @TestUseOnly
    public abstract void reset();

    private static void checkForIllegalLockFromRefreshThread(@NotNull UpdateGraph updateGraph) {
        if (updateGraph.clock().currentState() == LogicalClock.State.Updating && updateGraph.currentThreadProcessesUpdates()) {
            throw new UnsupportedOperationException("Non-terminal notifications must not lock the update graph");
        }
    }

    private static void maybeLogStackTrace(String type) {
        if (STACK_DUMP_LOCKS) {
            log.info().append((CharSequence)"Update Graph ").append((Throwable)new LockDebugException(type)).endl();
        }
    }

    private static final class LockDebugException
    extends Exception {
        private LockDebugException(@NotNull String message) {
            super(String.format("%s: %s", Thread.currentThread().getName(), message));
        }
    }

    private static class RecordingLock
    implements Lock {
        private final String name;
        private final Lock delegate;
        private final IntrusiveDoublyLinkedQueue<RecordedLockAcquisition> outstandingRecordings = new IntrusiveDoublyLinkedQueue(IntrusiveDoublyLinkedNode.Adapter.getInstance());
        private final ThreadLocal<Deque<RecordedLockAcquisition>> threadRecordings = ThreadLocal.withInitial(ArrayDeque::new);

        RecordingLock(@NotNull String name, @NotNull Lock delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        @Override
        public void lock() {
            this.delegate.lock();
            this.pushRecording(new LockDebugException(String.format("Recorded %s.lock()", this.name)));
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.delegate.lockInterruptibly();
            this.pushRecording(new LockDebugException(String.format("Recorded %s.lockInterruptibly()", this.name)));
        }

        @Override
        public boolean tryLock() {
            if (this.delegate.tryLock()) {
                this.pushRecording(new LockDebugException(String.format("Recorded %s.tryLock()", this.name)));
                return true;
            }
            return false;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (this.delegate.tryLock(time, unit)) {
                this.pushRecording(new LockDebugException(String.format("Recorded %s.tryLock(%d, %s)", new Object[]{this.name, time, unit})));
                return true;
            }
            return false;
        }

        @Override
        public void unlock() {
            this.popRecording();
            this.delegate.unlock();
        }

        @Override
        @NotNull
        public Condition newCondition() {
            return this.delegate.newCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<RecordedLockAcquisition> getOutstandingRecordedAcquisitions() {
            IntrusiveDoublyLinkedQueue<RecordedLockAcquisition> intrusiveDoublyLinkedQueue = this.outstandingRecordings;
            synchronized (intrusiveDoublyLinkedQueue) {
                if (this.outstandingRecordings.isEmpty()) {
                    return List.of();
                }
                return this.outstandingRecordings.stream().collect(Collectors.toList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pushRecording(@NotNull LockDebugException pendingException) {
            RecordedLockAcquisition recordedLockAcquisition;
            try {
                recordedLockAcquisition = new RecordedLockAcquisition(pendingException);
                this.threadRecordings.get().push(recordedLockAcquisition);
            }
            catch (Throwable t) {
                this.delegate.unlock();
                log.warn().append((CharSequence)"Unexpected exception while pushing lock context: ").append(t).endl();
                throw t;
            }
            try {
                IntrusiveDoublyLinkedQueue<RecordedLockAcquisition> t = this.outstandingRecordings;
                synchronized (t) {
                    this.outstandingRecordings.offer((Object)recordedLockAcquisition);
                }
            }
            catch (Throwable t) {
                this.delegate.unlock();
                this.threadRecordings.get().pop();
                log.warn().append((CharSequence)"Unexpected exception while recording outstanding lock context: ").append(t).endl();
                throw t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void popRecording() {
            try {
                RecordedLockAcquisition recordedLockAcquisition = this.threadRecordings.get().pop();
                IntrusiveDoublyLinkedQueue<RecordedLockAcquisition> intrusiveDoublyLinkedQueue = this.outstandingRecordings;
                synchronized (intrusiveDoublyLinkedQueue) {
                    this.outstandingRecordings.remove((Object)recordedLockAcquisition);
                }
            }
            catch (Throwable t) {
                log.warn().append((CharSequence)"Unexpected exception while popping lock context: ").append(t).endl();
            }
        }
    }

    private static class RecordedLockAcquisition
    extends IntrusiveDoublyLinkedNode.Impl<RecordedLockAcquisition> {
        private final LockDebugException pendingException;

        private RecordedLockAcquisition(@NotNull LockDebugException pendingException) {
            this.pendingException = pendingException;
        }
    }

    private static final class RecordedReadWriteLockAccessor
    extends ReentrantReadWriteLockAccessor {
        private final RecordingLock readLock = new RecordingLock("readLock", super.readLock());
        private final RecordingLock writeLock = new RecordingLock("writeLock", super.writeLock());

        private RecordedReadWriteLockAccessor() {
        }

        @Override
        public RecordingLock readLock() {
            return this.readLock;
        }

        @Override
        public RecordingLock writeLock() {
            return this.writeLock;
        }
    }

    private static class ReentrantReadWriteLockAccessor
    implements ReadWriteLockAccessor {
        private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);

        private ReentrantReadWriteLockAccessor() {
        }

        @Override
        public final boolean readLockIsHeldByCurrentThread() {
            return this.rwLock.getReadHoldCount() > 0;
        }

        @Override
        public Lock readLock() {
            return this.rwLock.readLock();
        }

        @Override
        public final boolean writeLockIsHeldByCurrentThread() {
            return this.rwLock.isWriteLockedByCurrentThread();
        }

        @Override
        public Lock writeLock() {
            return this.rwLock.writeLock();
        }
    }

    private static class ExclusiveLock
    implements AwareFunctionalLock {
        private final UpdateGraph updateGraph;
        private final ReadWriteLockAccessor lockAccessor;
        private final Lock writeLock;

        private ExclusiveLock(@NotNull UpdateGraph updateGraph, @NotNull ReadWriteLockAccessor lockAccessor) {
            this.updateGraph = updateGraph;
            this.lockAccessor = lockAccessor;
            this.writeLock = lockAccessor.writeLock();
        }

        public final boolean isHeldByCurrentThread() {
            return this.lockAccessor.writeLockIsHeldByCurrentThread();
        }

        public final void lock() {
            UpdateGraphLock.checkForIllegalLockFromRefreshThread(this.updateGraph);
            this.checkForUpgradeAttempt();
            MutableBoolean lockSucceeded = new MutableBoolean(false);
            try {
                instrumentation.recordAction("Acquire UpdateGraph writeLock", () -> {
                    this.writeLock.lock();
                    lockSucceeded.setValue(true);
                });
                Assert.eq((Object)((Object)this.updateGraph.clock().currentState()), (String)"logicalClock.currentState()", (Object)((Object)LogicalClock.State.Idle));
                UpdateGraphLock.maybeLogStackTrace("locked (exclusive)");
            }
            catch (Throwable t) {
                if (lockSucceeded.isTrue()) {
                    this.writeLock.unlock();
                }
                throw t;
            }
        }

        public final void lockInterruptibly() throws InterruptedException {
            UpdateGraphLock.checkForIllegalLockFromRefreshThread(this.updateGraph);
            this.checkForUpgradeAttempt();
            MutableBoolean lockSucceeded = new MutableBoolean(false);
            try {
                instrumentation.recordActionInterruptibly("Acquire UpdateGraph writeLock interruptibly", (ThrowingRunnable<InterruptedException>)((ThrowingRunnable)() -> {
                    this.writeLock.lockInterruptibly();
                    lockSucceeded.setValue(true);
                }));
                Assert.eq((Object)((Object)this.updateGraph.clock().currentState()), (String)"logicalClock.currentState()", (Object)((Object)LogicalClock.State.Idle));
                UpdateGraphLock.maybeLogStackTrace("locked (exclusive)");
            }
            catch (Throwable t) {
                if (lockSucceeded.isTrue()) {
                    this.writeLock.unlock();
                }
                throw t;
            }
        }

        public final boolean tryLock() {
            UpdateGraphLock.checkForIllegalLockFromRefreshThread(this.updateGraph);
            this.checkForUpgradeAttempt();
            if (this.writeLock.tryLock()) {
                UpdateGraphLock.maybeLogStackTrace("locked (exclusive)");
                return true;
            }
            return false;
        }

        public final boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            UpdateGraphLock.checkForIllegalLockFromRefreshThread(this.updateGraph);
            this.checkForUpgradeAttempt();
            if (this.writeLock.tryLock(time, unit)) {
                UpdateGraphLock.maybeLogStackTrace("locked (exclusive)");
                return true;
            }
            return false;
        }

        public final void unlock() {
            Assert.eq((Object)((Object)this.updateGraph.clock().currentState()), (String)"logicalClock.currentState()", (Object)((Object)LogicalClock.State.Idle));
            this.writeLock.unlock();
            UpdateGraphLock.maybeLogStackTrace("unlocked (exclusive)");
        }

        @NotNull
        public final Condition newCondition() {
            return this.writeLock.newCondition();
        }

        private void checkForUpgradeAttempt() {
            if (this.lockAccessor.readLockIsHeldByCurrentThread()) {
                throw new UnsupportedOperationException("Cannot upgrade a shared lock to an exclusive lock");
            }
        }
    }

    private static class SharedLock
    implements AwareFunctionalLock {
        private final UpdateGraph updateGraph;
        private final ReadWriteLockAccessor lockAccessor;
        private final Lock readLock;

        private SharedLock(@NotNull UpdateGraph updateGraph, @NotNull ReadWriteLockAccessor lockAccessor) {
            this.updateGraph = updateGraph;
            this.lockAccessor = lockAccessor;
            this.readLock = lockAccessor.readLock();
        }

        public final boolean isHeldByCurrentThread() {
            return this.lockAccessor.readLockIsHeldByCurrentThread();
        }

        public final void lock() {
            UpdateGraphLock.checkForIllegalLockFromRefreshThread(this.updateGraph);
            MutableBoolean lockSucceeded = new MutableBoolean(false);
            try {
                instrumentation.recordAction("Acquire UpdateGraph readLock", () -> {
                    this.readLock.lock();
                    lockSucceeded.setValue(true);
                });
                UpdateGraphLock.maybeLogStackTrace("locked (shared)");
            }
            catch (Throwable t) {
                if (lockSucceeded.isTrue()) {
                    this.readLock.unlock();
                }
                throw t;
            }
        }

        public final void lockInterruptibly() throws InterruptedException {
            UpdateGraphLock.checkForIllegalLockFromRefreshThread(this.updateGraph);
            MutableBoolean lockSucceeded = new MutableBoolean(false);
            try {
                instrumentation.recordActionInterruptibly("Acquire UpdateGraph readLock interruptibly", (ThrowingRunnable<InterruptedException>)((ThrowingRunnable)() -> {
                    this.readLock.lockInterruptibly();
                    lockSucceeded.setValue(true);
                }));
                UpdateGraphLock.maybeLogStackTrace("locked (shared)");
            }
            catch (Throwable t) {
                if (lockSucceeded.isTrue()) {
                    this.readLock.unlock();
                }
                throw t;
            }
        }

        public final boolean tryLock() {
            UpdateGraphLock.checkForIllegalLockFromRefreshThread(this.updateGraph);
            if (this.readLock.tryLock()) {
                UpdateGraphLock.maybeLogStackTrace("locked (shared)");
                return true;
            }
            return false;
        }

        public final boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            UpdateGraphLock.checkForIllegalLockFromRefreshThread(this.updateGraph);
            if (this.readLock.tryLock(time, unit)) {
                UpdateGraphLock.maybeLogStackTrace("locked (shared)");
                return true;
            }
            return false;
        }

        public final void unlock() {
            this.readLock.unlock();
            UpdateGraphLock.maybeLogStackTrace("unlocked (shared)");
        }

        @NotNull
        public final Condition newCondition() {
            throw new UnsupportedOperationException("Shared locks do not support conditions");
        }
    }

    private static interface ReadWriteLockAccessor {
        public boolean readLockIsHeldByCurrentThread();

        public Lock readLock();

        public boolean writeLockIsHeldByCurrentThread();

        public Lock writeLock();
    }

    private static final class ResettableUpdateGraphLock
    extends UpdateGraphLock {
        private RecordedReadWriteLockAccessor lockAccessor;
        private volatile AwareFunctionalLock sharedLock;
        private volatile AwareFunctionalLock exclusiveLock;

        private ResettableUpdateGraphLock(@NotNull UpdateGraph updateGraph) {
            super(updateGraph);
            this.initialize();
        }

        private synchronized void initialize() {
            this.lockAccessor = new RecordedReadWriteLockAccessor();
            this.sharedLock = new SharedLock(this.updateGraph, this.lockAccessor);
            this.exclusiveLock = new ExclusiveLock(this.updateGraph, this.lockAccessor);
        }

        @Override
        public AwareFunctionalLock sharedLock() {
            return this.sharedLock;
        }

        @Override
        public AwareFunctionalLock exclusiveLock() {
            return this.exclusiveLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TestUseOnly
        public synchronized void reset() {
            block4: {
                RecordingLock writeLock = this.lockAccessor.writeLock();
                try {
                    if (!this.lockAccessor.readLockIsHeldByCurrentThread() && !this.lockAccessor.writeLockIsHeldByCurrentThread() && writeLock.delegate.tryLock()) {
                        writeLock.delegate.unlock();
                        break block4;
                    }
                    RecordingLock readLock = this.lockAccessor.readLock();
                    List outstandingAcquisitions = Stream.concat(writeLock.getOutstandingRecordedAcquisitions().stream(), readLock.getOutstandingRecordedAcquisitions().stream()).map(rla -> rla.pendingException).collect(Collectors.toList());
                    throw new UncheckedDeephavenException("UpdateGraphLock held during reset", MultiException.maybeWrapInMultiException((String)"Multiple outstanding recorded acquisitions", outstandingAcquisitions));
                }
                finally {
                    this.initialize();
                }
            }
        }
    }

    private static final class FinalUpdateGraphLock
    extends UpdateGraphLock {
        private final AwareFunctionalLock sharedLock;
        private final AwareFunctionalLock exclusiveLock;

        private FinalUpdateGraphLock(@NotNull UpdateGraph updateGraph) {
            super(updateGraph);
            ReentrantReadWriteLockAccessor lockAccessor = new ReentrantReadWriteLockAccessor();
            this.sharedLock = new SharedLock(updateGraph, lockAccessor);
            this.exclusiveLock = new ExclusiveLock(updateGraph, lockAccessor);
        }

        @Override
        public AwareFunctionalLock sharedLock() {
            return this.sharedLock;
        }

        @Override
        public AwareFunctionalLock exclusiveLock() {
            return this.exclusiveLock;
        }

        @Override
        @TestUseOnly
        public void reset() {
            throw new UnsupportedOperationException("This UpdateGraphLock instance is not resettable");
        }
    }

    public static interface Instrumentation {
        default public void recordAction(@NotNull String description, @NotNull Runnable action) {
            action.run();
        }

        default public void recordActionInterruptibly(@NotNull String description, @NotNull ThrowingRunnable<InterruptedException> action) throws InterruptedException {
            action.run();
        }
    }
}

