/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.base.WeakReferenceManager;
import io.deephaven.engine.liveness.LivenessArtifact;
import io.deephaven.engine.updategraph.DynamicNode;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class UpdateSourceCombiner
extends LivenessArtifact
implements Runnable,
UpdateSourceRegistrar {
    private final UpdateGraph updateGraph;
    private final WeakReferenceManager<Runnable> combinedTables = new WeakReferenceManager(true);

    public UpdateSourceCombiner(UpdateGraph updateGraph) {
        this.updateGraph = updateGraph;
    }

    public void install() {
        this.updateGraph.addSource(this);
    }

    @Override
    public void run() {
        this.combinedTables.forEachValidReference(Runnable::run);
    }

    @Override
    public void addSource(@NotNull Runnable updateSource) {
        if (updateSource instanceof DynamicNode) {
            DynamicNode dynamicUpdateSource = (DynamicNode)((Object)updateSource);
            dynamicUpdateSource.setRefreshing(true);
            dynamicUpdateSource.addParentReference(this);
        }
        this.combinedTables.add((Object)updateSource);
    }

    @Override
    public void removeSource(@NotNull Runnable updateSource) {
        this.combinedTables.removeAll(Collections.singleton(updateSource));
    }

    @Override
    public void requestRefresh() {
        this.updateGraph.requestRefresh();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.updateGraph.removeSource(this);
    }

    @Override
    public boolean satisfied(long step) {
        return this.updateGraph.satisfied(step);
    }

    @Override
    public UpdateGraph getUpdateGraph() {
        return this.updateGraph;
    }
}

