/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.updategraph;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.log.LogOutput;
import io.deephaven.engine.updategraph.AbstractNotification;
import io.deephaven.engine.updategraph.NotificationQueue;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public final class WaitNotification
extends AbstractNotification {
    private final NotificationQueue.Dependency[] dependencies;
    private int satisfiedCount;
    private volatile boolean fired;

    private WaitNotification(NotificationQueue.Dependency ... dependencies) {
        super(false);
        this.dependencies = dependencies;
    }

    @Override
    public boolean canExecute(long step) {
        while (this.satisfiedCount < this.dependencies.length) {
            if (!this.dependencies[this.satisfiedCount].satisfied(step)) {
                return false;
            }
            ++this.satisfiedCount;
        }
        return true;
    }

    @Override
    public LogOutput append(LogOutput logOutput) {
        return logOutput.append((CharSequence)this.getClass().getSimpleName()).append((CharSequence)": for dependencies").append(LogOutput.APPENDABLE_COLLECTION_FORMATTER, Arrays.asList(this.dependencies));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.fired = true;
        WaitNotification waitNotification = this;
        synchronized (waitNotification) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await() throws InterruptedException {
        while (!this.fired) {
            WaitNotification waitNotification = this;
            synchronized (waitNotification) {
                if (!this.fired) {
                    this.wait();
                }
            }
        }
    }

    public static boolean waitForSatisfaction(long step, NotificationQueue.Dependency ... dependencies) {
        WaitNotification waitNotification = new WaitNotification(dependencies);
        if (NotificationQueue.Dependency.getUpdateGraph(null, dependencies).maybeAddNotification(waitNotification, step)) {
            try {
                waitNotification.await();
            }
            catch (InterruptedException e) {
                throw new UncheckedDeephavenException("Interrupted while awaiting dependency satisfaction for " + Arrays.stream(dependencies).map(Objects::toString).collect(Collectors.joining(",")) + " on step " + step, (Throwable)e);
            }
            return true;
        }
        return false;
    }
}

