/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.util.reference;

import io.deephaven.base.verify.Require;
import io.deephaven.util.annotations.TestUseOnly;
import io.deephaven.util.reference.CleanupReferenceProcessor;
import java.lang.ref.ReferenceQueue;

public enum CleanupReferenceProcessorInstance {
    LIVENESS(new CleanupReferenceProcessor("liveness", 1000L, (l, r, e) -> {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }));

    private final CleanupReferenceProcessor cleanupReferenceProcessor;

    private CleanupReferenceProcessorInstance(CleanupReferenceProcessor cleanupReferenceProcessor) {
        this.cleanupReferenceProcessor = (CleanupReferenceProcessor)Require.neqNull((Object)cleanupReferenceProcessor, (String)"cleanupReferenceProcessor");
    }

    public final <RT> ReferenceQueue<RT> getReferenceQueue() {
        return this.cleanupReferenceProcessor.getReferenceQueue();
    }

    @TestUseOnly
    public static void resetAllForUnitTests() {
        for (CleanupReferenceProcessorInstance instance : CleanupReferenceProcessorInstance.values()) {
            instance.cleanupReferenceProcessor.resetForUnitTests();
        }
        CleanupReferenceProcessor.getDefault().resetForUnitTests();
    }
}

