/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.util.systemicmarking;

import io.deephaven.configuration.Configuration;
import io.deephaven.engine.util.systemicmarking.SystemicObject;
import java.util.function.Supplier;

public class SystemicObjectTracker {
    private static final ThreadLocal<Boolean> SYSTEMIC_CREATION_THREAD = ThreadLocal.withInitial(() -> false);
    private static final boolean SYSTEMIC_OBJECT_MARKING_ENABLED = Configuration.getInstance().getBooleanWithDefault("SystemicObjectTracker.enabled", false);

    public static boolean isSystemicObjectMarkingEnabled() {
        return SYSTEMIC_OBJECT_MARKING_ENABLED;
    }

    public static boolean isSystemicThread() {
        return SYSTEMIC_OBJECT_MARKING_ENABLED && SYSTEMIC_CREATION_THREAD.get() != false;
    }

    public static void markThreadSystemic() {
        if (SYSTEMIC_OBJECT_MARKING_ENABLED) {
            SYSTEMIC_CREATION_THREAD.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeSystemically(boolean systemicThread, Supplier<T> supplier) {
        if (!SYSTEMIC_OBJECT_MARKING_ENABLED) {
            return supplier.get();
        }
        boolean oldSystemic = SYSTEMIC_CREATION_THREAD.get();
        if (oldSystemic != systemicThread) {
            SYSTEMIC_CREATION_THREAD.set(systemicThread);
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (oldSystemic != systemicThread) {
                SYSTEMIC_CREATION_THREAD.set(oldSystemic);
            }
        }
    }

    public static boolean isSystemic(SystemicObject o) {
        if (!SYSTEMIC_OBJECT_MARKING_ENABLED) {
            return true;
        }
        return o.isSystemicObject();
    }
}

