/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public final class DoubleSubVector
extends DoubleVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final DoubleVector innerVector;
    private final long[] positions;

    public DoubleSubVector(@NotNull DoubleVector innerVector, @NotNull long[] positions) {
        this.innerVector = innerVector;
        this.positions = positions;
    }

    @Override
    public double get(long index) {
        if (index < 0L || index >= (long)this.positions.length) {
            return -1.7976931348623157E308;
        }
        return this.innerVector.get(this.positions[(int)index]);
    }

    @Override
    public DoubleVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositionRange(this.positions, fromIndexInclusive, toIndexExclusive));
    }

    @Override
    public DoubleVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositions(this.positions, positions));
    }

    public long size() {
        return this.positions.length;
    }
}

