/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.qst.type.FloatType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.PrimitiveVectorType;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.vector.FloatVectorDirect;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FloatVector
extends Vector<FloatVector>,
Iterable<Float> {
    public static final long serialVersionUID = -1373264425081841175L;

    public static PrimitiveVectorType<FloatVector, Float> type() {
        return PrimitiveVectorType.of(FloatVector.class, (PrimitiveType)FloatType.of());
    }

    public float get(long var1);

    @Override
    public FloatVector subVector(long var1, long var3);

    @Override
    public FloatVector subVectorByPositions(long[] var1);

    public float[] toArray();

    public float[] copyToArray();

    @Override
    public FloatVector getDirect();

    @FinalDefault
    default public CloseablePrimitiveIteratorOfFloat iterator() {
        return this.iterator(0L, this.size());
    }

    default public CloseablePrimitiveIteratorOfFloat iterator(final long fromIndexInclusive, final long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        return new CloseablePrimitiveIteratorOfFloat(){
            long nextIndex;
            {
                this.nextIndex = fromIndexInclusive;
            }

            public float nextFloat() {
                return FloatVector.this.get(this.nextIndex++);
            }

            public boolean hasNext() {
                return this.nextIndex < toIndexExclusive;
            }
        };
    }

    @Override
    @FinalDefault
    default public Class<?> getComponentType() {
        return Float.TYPE;
    }

    @Override
    @FinalDefault
    default public String toString(int prefixLength) {
        return FloatVector.toString(this, prefixLength);
    }

    public static String floatValToString(Object val) {
        return val == null ? " " : FloatVector.primitiveFloatValToString(((Float)val).floatValue());
    }

    public static String primitiveFloatValToString(float val) {
        return val == -3.4028235E38f ? " " : Float.toString(val);
    }

    public static String toString(@NotNull FloatVector vector, int prefixLength) {
        if (vector.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        int displaySize = (int)Math.min(vector.size(), (long)prefixLength);
        try (CloseablePrimitiveIteratorOfFloat iterator = vector.iterator(0L, displaySize);){
            builder.append(FloatVector.primitiveFloatValToString(iterator.nextFloat()));
            iterator.forEachRemaining(value -> builder.append(',').append(FloatVector.primitiveFloatValToString(value)));
        }
        if ((long)displaySize == vector.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }

    public static boolean equals(@NotNull FloatVector aVector, @Nullable Object bObj) {
        if (aVector == bObj) {
            return true;
        }
        if (!(bObj instanceof FloatVector)) {
            return false;
        }
        FloatVector bVector = (FloatVector)bObj;
        long size = aVector.size();
        if (size != bVector.size()) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        try (CloseablePrimitiveIteratorOfFloat aIterator = aVector.iterator();
             CloseablePrimitiveIteratorOfFloat bIterator = bVector.iterator();){
            while (aIterator.hasNext()) {
                if (Float.floatToIntBits(aIterator.nextFloat()) == Float.floatToIntBits(bIterator.nextFloat())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static int hashCode(@NotNull FloatVector vector) {
        int result = 1;
        if (vector.isEmpty()) {
            return result;
        }
        try (CloseablePrimitiveIteratorOfFloat iterator = vector.iterator();){
            while (iterator.hasNext()) {
                result = 31 * result + Float.hashCode(iterator.nextFloat());
            }
        }
        return result;
    }

    public static abstract class Indirect
    implements FloatVector {
        @Override
        public float[] toArray() {
            int size = this.intSize("FloatVector.toArray");
            float[] result = new float[size];
            try (CloseablePrimitiveIteratorOfFloat iterator = this.iterator();){
                for (int ei = 0; ei < size; ++ei) {
                    result[ei] = iterator.nextFloat();
                }
            }
            return result;
        }

        @Override
        public float[] copyToArray() {
            return this.toArray();
        }

        @Override
        public FloatVector getDirect() {
            return new FloatVectorDirect(this.toArray());
        }

        public final String toString() {
            return FloatVector.toString(this, 10);
        }

        public final boolean equals(Object obj) {
            return FloatVector.equals(this, obj);
        }

        public final int hashCode() {
            return FloatVector.hashCode(this);
        }

        protected final Object writeReplace() {
            return this.getDirect();
        }
    }
}

