/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.util.annotations.ArrayType;
import io.deephaven.util.annotations.ArrayTypeGetter;
import io.deephaven.vector.FloatSubVector;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.FloatVectorSlice;
import java.util.Arrays;

@ArrayType(type=float[].class)
public final class FloatVectorDirect
implements FloatVector {
    private static final long serialVersionUID = 3636374971797603565L;
    public static final FloatVector ZERO_LENGTH_VECTOR = new FloatVectorDirect(new float[0]);
    private final float[] data;

    public FloatVectorDirect(float ... data) {
        this.data = (float[])Require.neqNull((Object)data, (String)"data");
    }

    @Override
    public float get(long index) {
        if (index < 0L || index >= (long)this.data.length) {
            return -3.4028235E38f;
        }
        return this.data[(int)index];
    }

    @Override
    public FloatVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return new FloatVectorSlice(this, fromIndexInclusive, toIndexExclusive - fromIndexInclusive);
    }

    @Override
    public FloatVector subVectorByPositions(long[] positions) {
        return new FloatSubVector(this, positions);
    }

    @Override
    @ArrayTypeGetter
    public float[] toArray() {
        return this.data;
    }

    @Override
    public float[] copyToArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public CloseablePrimitiveIteratorOfFloat iterator(long fromIndexInclusive, long toIndexExclusive) {
        if (fromIndexInclusive == 0L && toIndexExclusive == (long)this.data.length) {
            return CloseablePrimitiveIteratorOfFloat.of((float[])this.data);
        }
        return FloatVector.super.iterator(fromIndexInclusive, toIndexExclusive);
    }

    public long size() {
        return this.data.length;
    }

    @Override
    public FloatVectorDirect getDirect() {
        return this;
    }

    public String toString() {
        return FloatVector.toString(this, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatVectorDirect) {
            return Arrays.equals(this.data, ((FloatVectorDirect)obj).data);
        }
        return FloatVector.equals(this, obj);
    }

    public int hashCode() {
        return FloatVector.hashCode(this);
    }
}

