/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.ClampUtil;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.FloatVectorDirect;
import io.deephaven.vector.Vector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class FloatVectorSlice
extends FloatVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final FloatVector innerVector;
    private final long offsetIndex;
    private final long length;
    private final long innerVectorValidFromInclusive;
    private final long innerVectorValidToExclusive;

    private FloatVectorSlice(@NotNull FloatVector innerVector, long offsetIndex, long length, long innerVectorValidFromInclusive, long innerVectorValidToExclusive) {
        Assert.geqZero((long)length, (String)"length");
        Assert.leq((long)innerVectorValidFromInclusive, (String)"innerArrayValidFromInclusive", (long)innerVectorValidToExclusive, (String)"innerArrayValidToExclusive");
        this.innerVector = innerVector;
        this.offsetIndex = offsetIndex;
        this.length = length;
        this.innerVectorValidFromInclusive = innerVectorValidFromInclusive;
        this.innerVectorValidToExclusive = innerVectorValidToExclusive;
    }

    public FloatVectorSlice(@NotNull FloatVector innerVector, long offsetIndex, long length) {
        this(innerVector, offsetIndex, length, ClampUtil.clampLong((long)0L, (long)innerVector.size(), (long)offsetIndex), ClampUtil.clampLong((long)0L, (long)innerVector.size(), (long)(offsetIndex + length)));
    }

    @Override
    public float get(long index) {
        return this.innerVector.get(Vector.clampIndex(this.innerVectorValidFromInclusive, this.innerVectorValidToExclusive, index + this.offsetIndex));
    }

    @Override
    public FloatVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        long newLength = toIndexExclusive - fromIndexInclusive;
        long newOffsetIndex = this.offsetIndex + fromIndexInclusive;
        return new FloatVectorSlice(this.innerVector, newOffsetIndex, newLength, ClampUtil.clampLong((long)this.innerVectorValidFromInclusive, (long)this.innerVectorValidToExclusive, (long)newOffsetIndex), ClampUtil.clampLong((long)this.innerVectorValidFromInclusive, (long)this.innerVectorValidToExclusive, (long)(newOffsetIndex + newLength)));
    }

    @Override
    public FloatVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Arrays.stream(positions).map(position -> Vector.clampIndex(this.innerVectorValidFromInclusive, this.innerVectorValidToExclusive, position + this.offsetIndex)).toArray());
    }

    @Override
    public float[] toArray() {
        if (this.innerVector instanceof FloatVectorDirect && this.offsetIndex >= this.innerVectorValidFromInclusive && this.offsetIndex + this.length <= this.innerVectorValidToExclusive) {
            return Arrays.copyOfRange(this.innerVector.toArray(), (int)this.offsetIndex, (int)(this.offsetIndex + this.length));
        }
        return super.toArray();
    }

    @Override
    public CloseablePrimitiveIteratorOfFloat iterator(long fromIndexInclusive, long toIndexExclusive) {
        long includedInnerLength;
        long firstIncludedInnerOffset;
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        long totalWanted = toIndexExclusive - fromIndexInclusive;
        long nextIndexWanted = fromIndexInclusive + this.offsetIndex;
        long includedInitialNulls = nextIndexWanted < this.innerVectorValidFromInclusive ? Math.min(this.innerVectorValidFromInclusive - nextIndexWanted, totalWanted) : 0L;
        long remaining = totalWanted - includedInitialNulls;
        if ((nextIndexWanted += includedInitialNulls) < this.innerVectorValidToExclusive) {
            firstIncludedInnerOffset = nextIndexWanted;
            includedInnerLength = Math.min(this.innerVectorValidToExclusive - nextIndexWanted, remaining);
            remaining -= includedInnerLength;
        } else {
            firstIncludedInnerOffset = -1L;
            includedInnerLength = 0L;
        }
        CloseablePrimitiveIteratorOfFloat initialNullsIterator = includedInitialNulls > 0L ? CloseablePrimitiveIteratorOfFloat.repeat((float)-3.4028235E38f, (long)includedInitialNulls) : null;
        CloseablePrimitiveIteratorOfFloat innerIterator = includedInnerLength > 0L ? this.innerVector.iterator(firstIncludedInnerOffset, firstIncludedInnerOffset + includedInnerLength) : null;
        CloseablePrimitiveIteratorOfFloat finalNullsIterator = remaining > 0L ? CloseablePrimitiveIteratorOfFloat.repeat((float)-3.4028235E38f, (long)remaining) : null;
        return CloseablePrimitiveIteratorOfFloat.maybeConcat((CloseablePrimitiveIteratorOfFloat)initialNullsIterator, (CloseablePrimitiveIteratorOfFloat)innerIterator, (CloseablePrimitiveIteratorOfFloat)finalNullsIterator);
    }

    public long size() {
        return this.length;
    }
}

