/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.vector.IntVector;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public final class IntSubVector
extends IntVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final IntVector innerVector;
    private final long[] positions;

    public IntSubVector(@NotNull IntVector innerVector, @NotNull long[] positions) {
        this.innerVector = innerVector;
        this.positions = positions;
    }

    @Override
    public int get(long index) {
        if (index < 0L || index >= (long)this.positions.length) {
            return Integer.MIN_VALUE;
        }
        return this.innerVector.get(this.positions[(int)index]);
    }

    @Override
    public IntVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositionRange(this.positions, fromIndexInclusive, toIndexExclusive));
    }

    @Override
    public IntVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositions(this.positions, positions));
    }

    public long size() {
        return this.positions.length;
    }
}

