/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.util.annotations.ArrayType;
import io.deephaven.util.annotations.ArrayTypeGetter;
import io.deephaven.vector.IntSubVector;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.IntVectorSlice;
import java.util.Arrays;

@ArrayType(type=int[].class)
public final class IntVectorDirect
implements IntVector {
    private static final long serialVersionUID = 3636374971797603565L;
    public static final IntVector ZERO_LENGTH_VECTOR = new IntVectorDirect(new int[0]);
    private final int[] data;

    public IntVectorDirect(int ... data) {
        this.data = (int[])Require.neqNull((Object)data, (String)"data");
    }

    @Override
    public int get(long index) {
        if (index < 0L || index >= (long)this.data.length) {
            return Integer.MIN_VALUE;
        }
        return this.data[(int)index];
    }

    @Override
    public IntVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return new IntVectorSlice(this, fromIndexInclusive, toIndexExclusive - fromIndexInclusive);
    }

    @Override
    public IntVector subVectorByPositions(long[] positions) {
        return new IntSubVector(this, positions);
    }

    @Override
    @ArrayTypeGetter
    public int[] toArray() {
        return this.data;
    }

    @Override
    public int[] copyToArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public CloseablePrimitiveIteratorOfInt iterator(long fromIndexInclusive, long toIndexExclusive) {
        if (fromIndexInclusive == 0L && toIndexExclusive == (long)this.data.length) {
            return CloseablePrimitiveIteratorOfInt.of((int[])this.data);
        }
        return IntVector.super.iterator(fromIndexInclusive, toIndexExclusive);
    }

    public long size() {
        return this.data.length;
    }

    @Override
    public IntVectorDirect getDirect() {
        return this;
    }

    public String toString() {
        return IntVector.toString(this, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntVectorDirect) {
            return Arrays.equals(this.data, ((IntVectorDirect)obj).data);
        }
        return IntVector.equals(this, obj);
    }

    public int hashCode() {
        return IntVector.hashCode(this);
    }
}

