/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.vector.LongVector;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public final class LongSubVector
extends LongVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final LongVector innerVector;
    private final long[] positions;

    public LongSubVector(@NotNull LongVector innerVector, @NotNull long[] positions) {
        this.innerVector = innerVector;
        this.positions = positions;
    }

    @Override
    public long get(long index) {
        if (index < 0L || index >= (long)this.positions.length) {
            return Long.MIN_VALUE;
        }
        return this.innerVector.get(this.positions[(int)index]);
    }

    @Override
    public LongVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositionRange(this.positions, fromIndexInclusive, toIndexExclusive));
    }

    @Override
    public LongVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositions(this.positions, positions));
    }

    public long size() {
        return this.positions.length;
    }
}

