/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.qst.type.LongType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.PrimitiveVectorType;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LongVector
extends Vector<LongVector>,
Iterable<Long> {
    public static final long serialVersionUID = -1373264425081841175L;

    public static PrimitiveVectorType<LongVector, Long> type() {
        return PrimitiveVectorType.of(LongVector.class, (PrimitiveType)LongType.of());
    }

    public long get(long var1);

    @Override
    public LongVector subVector(long var1, long var3);

    @Override
    public LongVector subVectorByPositions(long[] var1);

    public long[] toArray();

    public long[] copyToArray();

    @Override
    public LongVector getDirect();

    @FinalDefault
    default public CloseablePrimitiveIteratorOfLong iterator() {
        return this.iterator(0L, this.size());
    }

    default public CloseablePrimitiveIteratorOfLong iterator(final long fromIndexInclusive, final long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        return new CloseablePrimitiveIteratorOfLong(){
            long nextIndex;
            {
                this.nextIndex = fromIndexInclusive;
            }

            public long nextLong() {
                return LongVector.this.get(this.nextIndex++);
            }

            public boolean hasNext() {
                return this.nextIndex < toIndexExclusive;
            }
        };
    }

    @Override
    @FinalDefault
    default public Class<?> getComponentType() {
        return Long.TYPE;
    }

    @Override
    @FinalDefault
    default public String toString(int prefixLength) {
        return LongVector.toString(this, prefixLength);
    }

    public static String longValToString(Object val) {
        return val == null ? " " : LongVector.primitiveLongValToString((Long)val);
    }

    public static String primitiveLongValToString(long val) {
        return val == Long.MIN_VALUE ? " " : Long.toString(val);
    }

    public static String toString(@NotNull LongVector vector, int prefixLength) {
        if (vector.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        int displaySize = (int)Math.min(vector.size(), (long)prefixLength);
        try (CloseablePrimitiveIteratorOfLong iterator = vector.iterator(0L, displaySize);){
            builder.append(LongVector.primitiveLongValToString(iterator.nextLong()));
            iterator.forEachRemaining(value -> builder.append(',').append(LongVector.primitiveLongValToString(value)));
        }
        if ((long)displaySize == vector.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }

    public static boolean equals(@NotNull LongVector aVector, @Nullable Object bObj) {
        if (aVector == bObj) {
            return true;
        }
        if (!(bObj instanceof LongVector)) {
            return false;
        }
        LongVector bVector = (LongVector)bObj;
        long size = aVector.size();
        if (size != bVector.size()) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        try (CloseablePrimitiveIteratorOfLong aIterator = aVector.iterator();
             CloseablePrimitiveIteratorOfLong bIterator = bVector.iterator();){
            while (aIterator.hasNext()) {
                if (aIterator.nextLong() == bIterator.nextLong()) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static int hashCode(@NotNull LongVector vector) {
        int result = 1;
        if (vector.isEmpty()) {
            return result;
        }
        try (CloseablePrimitiveIteratorOfLong iterator = vector.iterator();){
            while (iterator.hasNext()) {
                result = 31 * result + Long.hashCode(iterator.nextLong());
            }
        }
        return result;
    }

    public static abstract class Indirect
    implements LongVector {
        @Override
        public long[] toArray() {
            int size = this.intSize("LongVector.toArray");
            long[] result = new long[size];
            try (CloseablePrimitiveIteratorOfLong iterator = this.iterator();){
                for (int ei = 0; ei < size; ++ei) {
                    result[ei] = iterator.nextLong();
                }
            }
            return result;
        }

        @Override
        public long[] copyToArray() {
            return this.toArray();
        }

        @Override
        public LongVector getDirect() {
            return new LongVectorDirect(this.toArray());
        }

        public final String toString() {
            return LongVector.toString(this, 10);
        }

        public final boolean equals(Object obj) {
            return LongVector.equals(this, obj);
        }

        public final int hashCode() {
            return LongVector.hashCode(this);
        }

        protected final Object writeReplace() {
            return this.getDirect();
        }
    }
}

