/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.util.annotations.ArrayType;
import io.deephaven.util.annotations.ArrayTypeGetter;
import io.deephaven.vector.LongSubVector;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorSlice;
import java.util.Arrays;

@ArrayType(type=long[].class)
public final class LongVectorDirect
implements LongVector {
    private static final long serialVersionUID = 3636374971797603565L;
    public static final LongVector ZERO_LENGTH_VECTOR = new LongVectorDirect(new long[0]);
    private final long[] data;

    public LongVectorDirect(long ... data) {
        this.data = (long[])Require.neqNull((Object)data, (String)"data");
    }

    @Override
    public long get(long index) {
        if (index < 0L || index >= (long)this.data.length) {
            return Long.MIN_VALUE;
        }
        return this.data[(int)index];
    }

    @Override
    public LongVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return new LongVectorSlice(this, fromIndexInclusive, toIndexExclusive - fromIndexInclusive);
    }

    @Override
    public LongVector subVectorByPositions(long[] positions) {
        return new LongSubVector(this, positions);
    }

    @Override
    @ArrayTypeGetter
    public long[] toArray() {
        return this.data;
    }

    @Override
    public long[] copyToArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public CloseablePrimitiveIteratorOfLong iterator(long fromIndexInclusive, long toIndexExclusive) {
        if (fromIndexInclusive == 0L && toIndexExclusive == (long)this.data.length) {
            return CloseablePrimitiveIteratorOfLong.of((long[])this.data);
        }
        return LongVector.super.iterator(fromIndexInclusive, toIndexExclusive);
    }

    public long size() {
        return this.data.length;
    }

    @Override
    public LongVectorDirect getDirect() {
        return this;
    }

    public String toString() {
        return LongVector.toString(this, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongVectorDirect) {
            return Arrays.equals(this.data, ((LongVectorDirect)obj).data);
        }
        return LongVector.equals(this, obj);
    }

    public int hashCode() {
        return LongVector.hashCode(this);
    }
}

