/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.ClampUtil;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.Vector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LongVectorSlice
extends LongVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final LongVector innerVector;
    private final long offsetIndex;
    private final long length;
    private final long innerVectorValidFromInclusive;
    private final long innerVectorValidToExclusive;

    private LongVectorSlice(@NotNull LongVector innerVector, long offsetIndex, long length, long innerVectorValidFromInclusive, long innerVectorValidToExclusive) {
        Assert.geqZero((long)length, (String)"length");
        Assert.leq((long)innerVectorValidFromInclusive, (String)"innerArrayValidFromInclusive", (long)innerVectorValidToExclusive, (String)"innerArrayValidToExclusive");
        this.innerVector = innerVector;
        this.offsetIndex = offsetIndex;
        this.length = length;
        this.innerVectorValidFromInclusive = innerVectorValidFromInclusive;
        this.innerVectorValidToExclusive = innerVectorValidToExclusive;
    }

    public LongVectorSlice(@NotNull LongVector innerVector, long offsetIndex, long length) {
        this(innerVector, offsetIndex, length, ClampUtil.clampLong((long)0L, (long)innerVector.size(), (long)offsetIndex), ClampUtil.clampLong((long)0L, (long)innerVector.size(), (long)(offsetIndex + length)));
    }

    @Override
    public long get(long index) {
        return this.innerVector.get(Vector.clampIndex(this.innerVectorValidFromInclusive, this.innerVectorValidToExclusive, index + this.offsetIndex));
    }

    @Override
    public LongVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        long newLength = toIndexExclusive - fromIndexInclusive;
        long newOffsetIndex = this.offsetIndex + fromIndexInclusive;
        return new LongVectorSlice(this.innerVector, newOffsetIndex, newLength, ClampUtil.clampLong((long)this.innerVectorValidFromInclusive, (long)this.innerVectorValidToExclusive, (long)newOffsetIndex), ClampUtil.clampLong((long)this.innerVectorValidFromInclusive, (long)this.innerVectorValidToExclusive, (long)(newOffsetIndex + newLength)));
    }

    @Override
    public LongVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Arrays.stream(positions).map(position -> Vector.clampIndex(this.innerVectorValidFromInclusive, this.innerVectorValidToExclusive, position + this.offsetIndex)).toArray());
    }

    @Override
    public long[] toArray() {
        if (this.innerVector instanceof LongVectorDirect && this.offsetIndex >= this.innerVectorValidFromInclusive && this.offsetIndex + this.length <= this.innerVectorValidToExclusive) {
            return Arrays.copyOfRange(this.innerVector.toArray(), (int)this.offsetIndex, (int)(this.offsetIndex + this.length));
        }
        return super.toArray();
    }

    @Override
    public CloseablePrimitiveIteratorOfLong iterator(long fromIndexInclusive, long toIndexExclusive) {
        long includedInnerLength;
        long firstIncludedInnerOffset;
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        long totalWanted = toIndexExclusive - fromIndexInclusive;
        long nextIndexWanted = fromIndexInclusive + this.offsetIndex;
        long includedInitialNulls = nextIndexWanted < this.innerVectorValidFromInclusive ? Math.min(this.innerVectorValidFromInclusive - nextIndexWanted, totalWanted) : 0L;
        long remaining = totalWanted - includedInitialNulls;
        if ((nextIndexWanted += includedInitialNulls) < this.innerVectorValidToExclusive) {
            firstIncludedInnerOffset = nextIndexWanted;
            includedInnerLength = Math.min(this.innerVectorValidToExclusive - nextIndexWanted, remaining);
            remaining -= includedInnerLength;
        } else {
            firstIncludedInnerOffset = -1L;
            includedInnerLength = 0L;
        }
        CloseablePrimitiveIteratorOfLong initialNullsIterator = includedInitialNulls > 0L ? CloseablePrimitiveIteratorOfLong.repeat((long)Long.MIN_VALUE, (long)includedInitialNulls) : null;
        CloseablePrimitiveIteratorOfLong innerIterator = includedInnerLength > 0L ? this.innerVector.iterator(firstIncludedInnerOffset, firstIncludedInnerOffset + includedInnerLength) : null;
        CloseablePrimitiveIteratorOfLong finalNullsIterator = remaining > 0L ? CloseablePrimitiveIteratorOfLong.repeat((long)Long.MIN_VALUE, (long)remaining) : null;
        return CloseablePrimitiveIteratorOfLong.maybeConcat((CloseablePrimitiveIteratorOfLong)initialNullsIterator, (CloseablePrimitiveIteratorOfLong)innerIterator, (CloseablePrimitiveIteratorOfLong)finalNullsIterator);
    }

    public long size() {
        return this.length;
    }
}

