/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public class ObjectSubVector<COMPONENT_TYPE>
extends ObjectVector.Indirect<COMPONENT_TYPE> {
    private static final long serialVersionUID = 1L;
    private final ObjectVector<COMPONENT_TYPE> innerVector;
    private final long[] positions;

    public ObjectSubVector(@NotNull ObjectVector<COMPONENT_TYPE> innerVector, @NotNull long[] positions) {
        this.innerVector = innerVector;
        this.positions = positions;
    }

    @Override
    public COMPONENT_TYPE get(long index) {
        if (index < 0L || index >= (long)this.positions.length) {
            return null;
        }
        return this.innerVector.get(this.positions[(int)index]);
    }

    @Override
    public ObjectVector<COMPONENT_TYPE> subVector(long fromIndexInclusive, long toIndexExclusive) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositionRange(this.positions, fromIndexInclusive, toIndexExclusive));
    }

    @Override
    public ObjectVector<COMPONENT_TYPE> subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositions(this.positions, positions));
    }

    public long size() {
        return this.positions.length;
    }

    @Override
    public Class<COMPONENT_TYPE> getComponentType() {
        return this.innerVector.getComponentType();
    }
}

