/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.ClampUtil;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorDirect;
import io.deephaven.vector.Vector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ObjectVectorSlice<COMPONENT_TYPE>
extends ObjectVector.Indirect<COMPONENT_TYPE> {
    private static final long serialVersionUID = 1L;
    private final ObjectVector<COMPONENT_TYPE> innerVector;
    private final long offsetIndex;
    private final long length;
    private final long innerVectorValidFromInclusive;
    private final long innerVectorValidToExclusive;

    private ObjectVectorSlice(@NotNull ObjectVector<COMPONENT_TYPE> innerVector, long offsetIndex, long length, long innerVectorValidFromInclusive, long innerVectorValidToExclusive) {
        Assert.geqZero((long)length, (String)"length");
        Assert.leq((long)innerVectorValidFromInclusive, (String)"innerArrayValidFromInclusive", (long)innerVectorValidToExclusive, (String)"innerArrayValidToExclusive");
        this.innerVector = innerVector;
        this.offsetIndex = offsetIndex;
        this.length = length;
        this.innerVectorValidFromInclusive = innerVectorValidFromInclusive;
        this.innerVectorValidToExclusive = innerVectorValidToExclusive;
    }

    public ObjectVectorSlice(@NotNull ObjectVector<COMPONENT_TYPE> innerVector, long offsetIndex, long length) {
        this(innerVector, offsetIndex, length, ClampUtil.clampLong((long)0L, (long)innerVector.size(), (long)offsetIndex), ClampUtil.clampLong((long)0L, (long)innerVector.size(), (long)(offsetIndex + length)));
    }

    @Override
    public COMPONENT_TYPE get(long index) {
        return this.innerVector.get(Vector.clampIndex(this.innerVectorValidFromInclusive, this.innerVectorValidToExclusive, index + this.offsetIndex));
    }

    @Override
    public ObjectVector<COMPONENT_TYPE> subVector(long fromIndexInclusive, long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        long newLength = toIndexExclusive - fromIndexInclusive;
        long newOffsetIndex = this.offsetIndex + fromIndexInclusive;
        return new ObjectVectorSlice<COMPONENT_TYPE>(this.innerVector, newOffsetIndex, newLength, ClampUtil.clampLong((long)this.innerVectorValidFromInclusive, (long)this.innerVectorValidToExclusive, (long)newOffsetIndex), ClampUtil.clampLong((long)this.innerVectorValidFromInclusive, (long)this.innerVectorValidToExclusive, (long)(newOffsetIndex + newLength)));
    }

    @Override
    public ObjectVector<COMPONENT_TYPE> subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Arrays.stream(positions).map(position -> Vector.clampIndex(this.innerVectorValidFromInclusive, this.innerVectorValidToExclusive, position + this.offsetIndex)).toArray());
    }

    @Override
    public COMPONENT_TYPE[] toArray() {
        if (this.innerVector instanceof ObjectVectorDirect && this.offsetIndex >= this.innerVectorValidFromInclusive && this.offsetIndex + this.length <= this.innerVectorValidToExclusive) {
            return Arrays.copyOfRange(this.innerVector.toArray(), (int)this.offsetIndex, (int)(this.offsetIndex + this.length));
        }
        return super.toArray();
    }

    @Override
    public CloseableIterator<COMPONENT_TYPE> iterator(long fromIndexInclusive, long toIndexExclusive) {
        long includedInnerLength;
        long firstIncludedInnerOffset;
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        long totalWanted = toIndexExclusive - fromIndexInclusive;
        long nextIndexWanted = fromIndexInclusive + this.offsetIndex;
        long includedInitialNulls = nextIndexWanted < this.innerVectorValidFromInclusive ? Math.min(this.innerVectorValidFromInclusive - nextIndexWanted, totalWanted) : 0L;
        long remaining = totalWanted - includedInitialNulls;
        if ((nextIndexWanted += includedInitialNulls) < this.innerVectorValidToExclusive) {
            firstIncludedInnerOffset = nextIndexWanted;
            includedInnerLength = Math.min(this.innerVectorValidToExclusive - nextIndexWanted, remaining);
            remaining -= includedInnerLength;
        } else {
            firstIncludedInnerOffset = -1L;
            includedInnerLength = 0L;
        }
        CloseableIterator initialNullsIterator = includedInitialNulls > 0L ? CloseableIterator.repeat(null, (long)includedInitialNulls) : null;
        CloseableIterator<COMPONENT_TYPE> innerIterator = includedInnerLength > 0L ? this.innerVector.iterator(firstIncludedInnerOffset, firstIncludedInnerOffset + includedInnerLength) : null;
        CloseableIterator finalNullsIterator = remaining > 0L ? CloseableIterator.repeat(null, (long)remaining) : null;
        return CloseableIterator.maybeConcat((CloseableIterator)initialNullsIterator, innerIterator, (CloseableIterator)finalNullsIterator);
    }

    public long size() {
        return this.length;
    }

    @Override
    public Class<COMPONENT_TYPE> getComponentType() {
        return this.innerVector.getComponentType();
    }
}

