/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfShort;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.PrimitiveVectorType;
import io.deephaven.qst.type.ShortType;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.vector.ShortVectorDirect;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ShortVector
extends Vector<ShortVector>,
Iterable<Short> {
    public static final long serialVersionUID = -1373264425081841175L;

    public static PrimitiveVectorType<ShortVector, Short> type() {
        return PrimitiveVectorType.of(ShortVector.class, (PrimitiveType)ShortType.of());
    }

    public short get(long var1);

    @Override
    public ShortVector subVector(long var1, long var3);

    @Override
    public ShortVector subVectorByPositions(long[] var1);

    public short[] toArray();

    public short[] copyToArray();

    @Override
    public ShortVector getDirect();

    @FinalDefault
    default public CloseablePrimitiveIteratorOfShort iterator() {
        return this.iterator(0L, this.size());
    }

    default public CloseablePrimitiveIteratorOfShort iterator(final long fromIndexInclusive, final long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        return new CloseablePrimitiveIteratorOfShort(){
            long nextIndex;
            {
                this.nextIndex = fromIndexInclusive;
            }

            public short nextShort() {
                return ShortVector.this.get(this.nextIndex++);
            }

            public boolean hasNext() {
                return this.nextIndex < toIndexExclusive;
            }
        };
    }

    @Override
    @FinalDefault
    default public Class<?> getComponentType() {
        return Short.TYPE;
    }

    @Override
    @FinalDefault
    default public String toString(int prefixLength) {
        return ShortVector.toString(this, prefixLength);
    }

    public static String shortValToString(Object val) {
        return val == null ? " " : ShortVector.primitiveShortValToString((Short)val);
    }

    public static String primitiveShortValToString(short val) {
        return val == Short.MIN_VALUE ? " " : Short.toString(val);
    }

    public static String toString(@NotNull ShortVector vector, int prefixLength) {
        if (vector.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        int displaySize = (int)Math.min(vector.size(), (long)prefixLength);
        try (CloseablePrimitiveIteratorOfShort iterator = vector.iterator(0L, displaySize);){
            builder.append(ShortVector.primitiveShortValToString(iterator.nextShort()));
            iterator.forEachRemaining(value -> builder.append(',').append(ShortVector.primitiveShortValToString(value)));
        }
        if ((long)displaySize == vector.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }

    public static boolean equals(@NotNull ShortVector aVector, @Nullable Object bObj) {
        if (aVector == bObj) {
            return true;
        }
        if (!(bObj instanceof ShortVector)) {
            return false;
        }
        ShortVector bVector = (ShortVector)bObj;
        long size = aVector.size();
        if (size != bVector.size()) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        try (CloseablePrimitiveIteratorOfShort aIterator = aVector.iterator();
             CloseablePrimitiveIteratorOfShort bIterator = bVector.iterator();){
            while (aIterator.hasNext()) {
                if (aIterator.nextShort() == bIterator.nextShort()) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static int hashCode(@NotNull ShortVector vector) {
        int result = 1;
        if (vector.isEmpty()) {
            return result;
        }
        try (CloseablePrimitiveIteratorOfShort iterator = vector.iterator();){
            while (iterator.hasNext()) {
                result = 31 * result + Short.hashCode(iterator.nextShort());
            }
        }
        return result;
    }

    public static abstract class Indirect
    implements ShortVector {
        @Override
        public short[] toArray() {
            int size = this.intSize("ShortVector.toArray");
            short[] result = new short[size];
            try (CloseablePrimitiveIteratorOfShort iterator = this.iterator();){
                for (int ei = 0; ei < size; ++ei) {
                    result[ei] = iterator.nextShort();
                }
            }
            return result;
        }

        @Override
        public short[] copyToArray() {
            return this.toArray();
        }

        @Override
        public ShortVector getDirect() {
            return new ShortVectorDirect(this.toArray());
        }

        public final String toString() {
            return ShortVector.toString(this, 10);
        }

        public final boolean equals(Object obj) {
            return ShortVector.equals(this, obj);
        }

        public final int hashCode() {
            return ShortVector.hashCode(this);
        }

        protected final Object writeReplace() {
            return this.getDirect();
        }
    }
}

