/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Assert;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ShortVector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.LongStream;
import org.jetbrains.annotations.NotNull;

public interface Vector<VECTOR_TYPE extends Vector<VECTOR_TYPE>>
extends Serializable,
LongSizedDataStructure {
    public static final long serialVersionUID = -2429677814745466454L;
    public static final String NULL_ELEMENT_STRING = " ";

    public VECTOR_TYPE subVector(long var1, long var3);

    public VECTOR_TYPE subVectorByPositions(long[] var1);

    public Object toArray();

    public Object copyToArray();

    public VECTOR_TYPE getDirect();

    public Class<?> getComponentType();

    public String toString(int var1);

    default public boolean isEmpty() {
        return this.size() == 0L;
    }

    public static long clampIndex(long validFromInclusive, long validToExclusive, long index) {
        return index < validFromInclusive || index >= validToExclusive ? -1L : index;
    }

    public static long[] mapSelectedPositionRange(@NotNull long[] currentPositions, long selectedRangeStartInclusive, long selectedRangeEndExclusive) {
        Assert.leq((long)selectedRangeStartInclusive, (String)"selectedRangeStartInclusive", (long)selectedRangeEndExclusive, (String)"selectedRangeEndExclusive");
        return LongStream.range(selectedRangeStartInclusive, selectedRangeEndExclusive).map(selected -> selected < 0L || selected >= (long)currentPositions.length ? -1L : currentPositions[(int)selected]).toArray();
    }

    public static long[] mapSelectedPositions(@NotNull long[] currentPositions, @NotNull long[] selectedPositions) {
        return Arrays.stream(selectedPositions).map(selected -> selected < 0L || selected >= (long)currentPositions.length ? -1L : currentPositions[(int)selected]).toArray();
    }

    public static Function<Object, String> classToHelper(Class<?> clazz) {
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return ByteVector::byteValToString;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return CharVector::charValToString;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return DoubleVector::doubleValToString;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return FloatVector::floatValToString;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return IntVector::intValToString;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return LongVector::longValToString;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return ShortVector::shortValToString;
        }
        return ObjectVector::defaultValToString;
    }
}

