/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.util.SimpleTypeMap;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.ByteVectorDirect;
import io.deephaven.vector.ByteVectorSlice;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.CharVectorDirect;
import io.deephaven.vector.CharVectorSlice;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.DoubleVectorDirect;
import io.deephaven.vector.DoubleVectorSlice;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.FloatVectorDirect;
import io.deephaven.vector.FloatVectorSlice;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.IntVectorDirect;
import io.deephaven.vector.IntVectorSlice;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.LongVectorSlice;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorDirect;
import io.deephaven.vector.ObjectVectorSlice;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.ShortVectorDirect;
import io.deephaven.vector.ShortVectorSlice;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public enum VectorFactory {
    Boolean{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            throw new UnsupportedOperationException("Vector is not implemented for primitive booleans");
        }

        @Override
        @NotNull
        public final Vector<?> vectorWrap(@NotNull Object array) {
            throw new UnsupportedOperationException("Vector is not implemented for primitive booleans");
        }

        @Override
        @NotNull
        public Vector<?> vectorWrap(@NotNull Object array, int offset, int capacity) {
            throw new UnsupportedOperationException("Vector is not implemented for primitive booleans");
        }
    }
    ,
    Char{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            return CharVector.class;
        }

        @NotNull
        public final CharVector vectorWrap(@NotNull Object array) {
            return new CharVectorDirect((char[])array);
        }

        @NotNull
        public CharVector vectorWrap(@NotNull Object array, int offset, int capacity) {
            return new CharVectorSlice(this.vectorWrap(array), offset, capacity);
        }
    }
    ,
    Byte{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            return ByteVector.class;
        }

        @NotNull
        public final ByteVector vectorWrap(@NotNull Object array) {
            return new ByteVectorDirect((byte[])array);
        }

        @NotNull
        public ByteVector vectorWrap(@NotNull Object array, int offset, int capacity) {
            return new ByteVectorSlice(this.vectorWrap(array), offset, capacity);
        }
    }
    ,
    Short{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            return ShortVector.class;
        }

        @NotNull
        public final ShortVector vectorWrap(@NotNull Object array) {
            return new ShortVectorDirect((short[])array);
        }

        @NotNull
        public ShortVector vectorWrap(@NotNull Object array, int offset, int capacity) {
            return new ShortVectorSlice(this.vectorWrap(array), offset, capacity);
        }
    }
    ,
    Int{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            return IntVector.class;
        }

        @NotNull
        public final IntVector vectorWrap(@NotNull Object array) {
            return new IntVectorDirect((int[])array);
        }

        @NotNull
        public IntVector vectorWrap(@NotNull Object array, int offset, int capacity) {
            return new IntVectorSlice(this.vectorWrap(array), offset, capacity);
        }
    }
    ,
    Long{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            return LongVector.class;
        }

        @NotNull
        public final LongVector vectorWrap(@NotNull Object array) {
            return new LongVectorDirect((long[])array);
        }

        @NotNull
        public LongVector vectorWrap(@NotNull Object array, int offset, int capacity) {
            return new LongVectorSlice(this.vectorWrap(array), offset, capacity);
        }
    }
    ,
    Float{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            return FloatVector.class;
        }

        @NotNull
        public final FloatVector vectorWrap(@NotNull Object array) {
            return new FloatVectorDirect((float[])array);
        }

        @NotNull
        public FloatVector vectorWrap(@NotNull Object array, int offset, int capacity) {
            return new FloatVectorSlice(this.vectorWrap(array), offset, capacity);
        }
    }
    ,
    Double{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            return DoubleVector.class;
        }

        @NotNull
        public final DoubleVector vectorWrap(@NotNull Object array) {
            return new DoubleVectorDirect((double[])array);
        }

        @NotNull
        public DoubleVector vectorWrap(@NotNull Object array, int offset, int capacity) {
            return new DoubleVectorSlice(this.vectorWrap(array), offset, capacity);
        }
    }
    ,
    Object{

        @Override
        @NotNull
        public Class<? extends Vector<?>> vectorType() {
            return ObjectVector.class;
        }

        @NotNull
        public final ObjectVector<?> vectorWrap(@NotNull Object array) {
            return new ObjectVectorDirect<Object>((Object[])array);
        }

        @NotNull
        public ObjectVector<?> vectorWrap(@NotNull Object array, int offset, int capacity) {
            return new ObjectVectorSlice(this.vectorWrap(array), offset, capacity);
        }
    };

    private static final SimpleTypeMap<VectorFactory> BY_ELEMENT_TYPE;

    public static VectorFactory forElementType(@NotNull Class<?> clazz) {
        return (VectorFactory)((Object)BY_ELEMENT_TYPE.get(clazz));
    }

    @NotNull
    public abstract Class<? extends Vector<?>> vectorType();

    @NotNull
    public abstract Vector<?> vectorWrap(@NotNull Object var1);

    @NotNull
    public abstract Vector<?> vectorWrap(@NotNull Object var1, int var2, int var3);

    static {
        BY_ELEMENT_TYPE = SimpleTypeMap.create((Object)((Object)Boolean), (Object)((Object)Char), (Object)((Object)Byte), (Object)((Object)Short), (Object)((Object)Int), (Object)((Object)Long), (Object)((Object)Float), (Object)((Object)Double), (Object)((Object)Object));
    }
}

