/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.vector.ByteVector;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public final class ByteSubVector
extends ByteVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final ByteVector innerVector;
    private final long[] positions;

    public ByteSubVector(@NotNull ByteVector innerVector, @NotNull long[] positions) {
        this.innerVector = innerVector;
        this.positions = positions;
    }

    @Override
    public byte get(long index) {
        if (index < 0L || index >= (long)this.positions.length) {
            return -128;
        }
        return this.innerVector.get(this.positions[(int)index]);
    }

    @Override
    public ByteVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositionRange(this.positions, fromIndexInclusive, toIndexExclusive));
    }

    @Override
    public ByteVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositions(this.positions, positions));
    }

    public long size() {
        return this.positions.length;
    }
}

