/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.qst.type.ByteType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.PrimitiveVectorType;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.vector.ByteVectorDirect;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ByteVector
extends Vector<ByteVector>,
Iterable<Byte> {
    public static final long serialVersionUID = -1373264425081841175L;

    public static PrimitiveVectorType<ByteVector, Byte> type() {
        return PrimitiveVectorType.of(ByteVector.class, (PrimitiveType)ByteType.of());
    }

    public byte get(long var1);

    @Override
    public ByteVector subVector(long var1, long var3);

    @Override
    public ByteVector subVectorByPositions(long[] var1);

    public byte[] toArray();

    public byte[] copyToArray();

    @Override
    public ByteVector getDirect();

    @FinalDefault
    default public CloseablePrimitiveIteratorOfByte iterator() {
        return this.iterator(0L, this.size());
    }

    default public CloseablePrimitiveIteratorOfByte iterator(final long fromIndexInclusive, final long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        return new CloseablePrimitiveIteratorOfByte(){
            long nextIndex;
            {
                this.nextIndex = fromIndexInclusive;
            }

            public byte nextByte() {
                return ByteVector.this.get(this.nextIndex++);
            }

            public boolean hasNext() {
                return this.nextIndex < toIndexExclusive;
            }
        };
    }

    @Override
    @FinalDefault
    default public Class<?> getComponentType() {
        return Byte.TYPE;
    }

    @Override
    @FinalDefault
    default public String toString(int prefixLength) {
        return ByteVector.toString(this, prefixLength);
    }

    public static String byteValToString(Object val) {
        return val == null ? " " : ByteVector.primitiveByteValToString((Byte)val);
    }

    public static String primitiveByteValToString(byte val) {
        return val == -128 ? " " : Byte.toString(val);
    }

    public static String toString(@NotNull ByteVector vector, int prefixLength) {
        if (vector.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        int displaySize = (int)Math.min(vector.size(), (long)prefixLength);
        try (CloseablePrimitiveIteratorOfByte iterator = vector.iterator(0L, displaySize);){
            builder.append(ByteVector.primitiveByteValToString(iterator.nextByte()));
            iterator.forEachRemaining(value -> builder.append(',').append(ByteVector.primitiveByteValToString(value)));
        }
        if ((long)displaySize == vector.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }

    public static boolean equals(@NotNull ByteVector aVector, @Nullable Object bObj) {
        if (aVector == bObj) {
            return true;
        }
        if (!(bObj instanceof ByteVector)) {
            return false;
        }
        ByteVector bVector = (ByteVector)bObj;
        long size = aVector.size();
        if (size != bVector.size()) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        try (CloseablePrimitiveIteratorOfByte aIterator = aVector.iterator();
             CloseablePrimitiveIteratorOfByte bIterator = bVector.iterator();){
            while (aIterator.hasNext()) {
                if (aIterator.nextByte() == bIterator.nextByte()) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static int hashCode(@NotNull ByteVector vector) {
        int result = 1;
        if (vector.isEmpty()) {
            return result;
        }
        try (CloseablePrimitiveIteratorOfByte iterator = vector.iterator();){
            while (iterator.hasNext()) {
                result = 31 * result + Byte.hashCode(iterator.nextByte());
            }
        }
        return result;
    }

    public static abstract class Indirect
    implements ByteVector {
        @Override
        public byte[] toArray() {
            int size = this.intSize("ByteVector.toArray");
            byte[] result = new byte[size];
            try (CloseablePrimitiveIteratorOfByte iterator = this.iterator();){
                for (int ei = 0; ei < size; ++ei) {
                    result[ei] = iterator.nextByte();
                }
            }
            return result;
        }

        @Override
        public byte[] copyToArray() {
            return this.toArray();
        }

        @Override
        public ByteVector getDirect() {
            return new ByteVectorDirect(this.toArray());
        }

        public final String toString() {
            return ByteVector.toString(this, 10);
        }

        public final boolean equals(Object obj) {
            return ByteVector.equals(this, obj);
        }

        public final int hashCode() {
            return ByteVector.hashCode(this);
        }

        protected final Object writeReplace() {
            return this.getDirect();
        }
    }
}

