/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.util.annotations.ArrayType;
import io.deephaven.util.annotations.ArrayTypeGetter;
import io.deephaven.vector.ByteSubVector;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.ByteVectorSlice;
import java.util.Arrays;

@ArrayType(type=byte[].class)
public final class ByteVectorDirect
implements ByteVector {
    private static final long serialVersionUID = 3636374971797603565L;
    public static final ByteVector ZERO_LENGTH_VECTOR = new ByteVectorDirect(new byte[0]);
    private final byte[] data;

    public ByteVectorDirect(byte ... data) {
        this.data = (byte[])Require.neqNull((Object)data, (String)"data");
    }

    @Override
    public byte get(long index) {
        if (index < 0L || index >= (long)this.data.length) {
            return -128;
        }
        return this.data[(int)index];
    }

    @Override
    public ByteVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return new ByteVectorSlice(this, fromIndexInclusive, toIndexExclusive - fromIndexInclusive);
    }

    @Override
    public ByteVector subVectorByPositions(long[] positions) {
        return new ByteSubVector(this, positions);
    }

    @Override
    @ArrayTypeGetter
    public byte[] toArray() {
        return this.data;
    }

    @Override
    public byte[] copyToArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public CloseablePrimitiveIteratorOfByte iterator(long fromIndexInclusive, long toIndexExclusive) {
        if (fromIndexInclusive == 0L && toIndexExclusive == (long)this.data.length) {
            return CloseablePrimitiveIteratorOfByte.of((byte[])this.data);
        }
        return ByteVector.super.iterator(fromIndexInclusive, toIndexExclusive);
    }

    public long size() {
        return this.data.length;
    }

    @Override
    public ByteVectorDirect getDirect() {
        return this;
    }

    public String toString() {
        return ByteVector.toString(this, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteVectorDirect) {
            return Arrays.equals(this.data, ((ByteVectorDirect)obj).data);
        }
        return ByteVector.equals(this, obj);
    }

    public int hashCode() {
        return ByteVector.hashCode(this);
    }
}

