/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.ClampUtil;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.ByteVectorDirect;
import io.deephaven.vector.Vector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ByteVectorSlice
extends ByteVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final ByteVector innerVector;
    private final long offsetIndex;
    private final long length;
    private final long innerVectorValidFromInclusive;
    private final long innerVectorValidToExclusive;

    private ByteVectorSlice(@NotNull ByteVector innerVector, long offsetIndex, long length, long innerVectorValidFromInclusive, long innerVectorValidToExclusive) {
        Assert.geqZero((long)length, (String)"length");
        Assert.leq((long)innerVectorValidFromInclusive, (String)"innerArrayValidFromInclusive", (long)innerVectorValidToExclusive, (String)"innerArrayValidToExclusive");
        this.innerVector = innerVector;
        this.offsetIndex = offsetIndex;
        this.length = length;
        this.innerVectorValidFromInclusive = innerVectorValidFromInclusive;
        this.innerVectorValidToExclusive = innerVectorValidToExclusive;
    }

    public ByteVectorSlice(@NotNull ByteVector innerVector, long offsetIndex, long length) {
        this(innerVector, offsetIndex, length, ClampUtil.clampLong((long)0L, (long)innerVector.size(), (long)offsetIndex), ClampUtil.clampLong((long)0L, (long)innerVector.size(), (long)(offsetIndex + length)));
    }

    @Override
    public byte get(long index) {
        return this.innerVector.get(Vector.clampIndex(this.innerVectorValidFromInclusive, this.innerVectorValidToExclusive, index + this.offsetIndex));
    }

    @Override
    public ByteVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        long newLength = toIndexExclusive - fromIndexInclusive;
        long newOffsetIndex = this.offsetIndex + fromIndexInclusive;
        return new ByteVectorSlice(this.innerVector, newOffsetIndex, newLength, ClampUtil.clampLong((long)this.innerVectorValidFromInclusive, (long)this.innerVectorValidToExclusive, (long)newOffsetIndex), ClampUtil.clampLong((long)this.innerVectorValidFromInclusive, (long)this.innerVectorValidToExclusive, (long)(newOffsetIndex + newLength)));
    }

    @Override
    public ByteVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Arrays.stream(positions).map(position -> Vector.clampIndex(this.innerVectorValidFromInclusive, this.innerVectorValidToExclusive, position + this.offsetIndex)).toArray());
    }

    @Override
    public byte[] toArray() {
        if (this.innerVector instanceof ByteVectorDirect && this.offsetIndex >= this.innerVectorValidFromInclusive && this.offsetIndex + this.length <= this.innerVectorValidToExclusive) {
            return Arrays.copyOfRange(this.innerVector.toArray(), (int)this.offsetIndex, (int)(this.offsetIndex + this.length));
        }
        return super.toArray();
    }

    @Override
    public CloseablePrimitiveIteratorOfByte iterator(long fromIndexInclusive, long toIndexExclusive) {
        long includedInnerLength;
        long firstIncludedInnerOffset;
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        long totalWanted = toIndexExclusive - fromIndexInclusive;
        long nextIndexWanted = fromIndexInclusive + this.offsetIndex;
        long includedInitialNulls = nextIndexWanted < this.innerVectorValidFromInclusive ? Math.min(this.innerVectorValidFromInclusive - nextIndexWanted, totalWanted) : 0L;
        long remaining = totalWanted - includedInitialNulls;
        if ((nextIndexWanted += includedInitialNulls) < this.innerVectorValidToExclusive) {
            firstIncludedInnerOffset = nextIndexWanted;
            includedInnerLength = Math.min(this.innerVectorValidToExclusive - nextIndexWanted, remaining);
            remaining -= includedInnerLength;
        } else {
            firstIncludedInnerOffset = -1L;
            includedInnerLength = 0L;
        }
        CloseablePrimitiveIteratorOfByte initialNullsIterator = includedInitialNulls > 0L ? CloseablePrimitiveIteratorOfByte.repeat((byte)-128, (long)includedInitialNulls) : null;
        CloseablePrimitiveIteratorOfByte innerIterator = includedInnerLength > 0L ? this.innerVector.iterator(firstIncludedInnerOffset, firstIncludedInnerOffset + includedInnerLength) : null;
        CloseablePrimitiveIteratorOfByte finalNullsIterator = remaining > 0L ? CloseablePrimitiveIteratorOfByte.repeat((byte)-128, (long)remaining) : null;
        return CloseablePrimitiveIteratorOfByte.maybeConcat((CloseablePrimitiveIteratorOfByte)initialNullsIterator, (CloseablePrimitiveIteratorOfByte)innerIterator, (CloseablePrimitiveIteratorOfByte)finalNullsIterator);
    }

    public long size() {
        return this.length;
    }
}

