/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.vector.CharVector;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public final class CharSubVector
extends CharVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final CharVector innerVector;
    private final long[] positions;

    public CharSubVector(@NotNull CharVector innerVector, @NotNull long[] positions) {
        this.innerVector = innerVector;
        this.positions = positions;
    }

    @Override
    public char get(long index) {
        if (index < 0L || index >= (long)this.positions.length) {
            return '\uffff';
        }
        return this.innerVector.get(this.positions[(int)index]);
    }

    @Override
    public CharVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositionRange(this.positions, fromIndexInclusive, toIndexExclusive));
    }

    @Override
    public CharVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositions(this.positions, positions));
    }

    public long size() {
        return this.positions.length;
    }
}

