/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfChar;
import io.deephaven.qst.type.CharType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.PrimitiveVectorType;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.vector.CharVectorDirect;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CharVector
extends Vector<CharVector>,
Iterable<Character> {
    public static final long serialVersionUID = -1373264425081841175L;

    public static PrimitiveVectorType<CharVector, Character> type() {
        return PrimitiveVectorType.of(CharVector.class, (PrimitiveType)CharType.of());
    }

    public char get(long var1);

    @Override
    public CharVector subVector(long var1, long var3);

    @Override
    public CharVector subVectorByPositions(long[] var1);

    public char[] toArray();

    public char[] copyToArray();

    @Override
    public CharVector getDirect();

    @FinalDefault
    default public CloseablePrimitiveIteratorOfChar iterator() {
        return this.iterator(0L, this.size());
    }

    default public CloseablePrimitiveIteratorOfChar iterator(final long fromIndexInclusive, final long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        return new CloseablePrimitiveIteratorOfChar(){
            long nextIndex;
            {
                this.nextIndex = fromIndexInclusive;
            }

            public char nextChar() {
                return CharVector.this.get(this.nextIndex++);
            }

            public boolean hasNext() {
                return this.nextIndex < toIndexExclusive;
            }
        };
    }

    @Override
    @FinalDefault
    default public Class<?> getComponentType() {
        return Character.TYPE;
    }

    @Override
    @FinalDefault
    default public String toString(int prefixLength) {
        return CharVector.toString(this, prefixLength);
    }

    public static String charValToString(Object val) {
        return val == null ? " " : CharVector.primitiveCharValToString(((Character)val).charValue());
    }

    public static String primitiveCharValToString(char val) {
        return val == '\uffff' ? " " : Character.toString(val);
    }

    public static String toString(@NotNull CharVector vector, int prefixLength) {
        if (vector.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        int displaySize = (int)Math.min(vector.size(), (long)prefixLength);
        try (CloseablePrimitiveIteratorOfChar iterator = vector.iterator(0L, displaySize);){
            builder.append(CharVector.primitiveCharValToString(iterator.nextChar()));
            iterator.forEachRemaining(value -> builder.append(',').append(CharVector.primitiveCharValToString(value)));
        }
        if ((long)displaySize == vector.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }

    public static boolean equals(@NotNull CharVector aVector, @Nullable Object bObj) {
        if (aVector == bObj) {
            return true;
        }
        if (!(bObj instanceof CharVector)) {
            return false;
        }
        CharVector bVector = (CharVector)bObj;
        long size = aVector.size();
        if (size != bVector.size()) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        try (CloseablePrimitiveIteratorOfChar aIterator = aVector.iterator();
             CloseablePrimitiveIteratorOfChar bIterator = bVector.iterator();){
            while (aIterator.hasNext()) {
                if (aIterator.nextChar() == bIterator.nextChar()) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static int hashCode(@NotNull CharVector vector) {
        int result = 1;
        if (vector.isEmpty()) {
            return result;
        }
        try (CloseablePrimitiveIteratorOfChar iterator = vector.iterator();){
            while (iterator.hasNext()) {
                result = 31 * result + Character.hashCode(iterator.nextChar());
            }
        }
        return result;
    }

    public static abstract class Indirect
    implements CharVector {
        @Override
        public char[] toArray() {
            int size = this.intSize("CharVector.toArray");
            char[] result = new char[size];
            try (CloseablePrimitiveIteratorOfChar iterator = this.iterator();){
                for (int ei = 0; ei < size; ++ei) {
                    result[ei] = iterator.nextChar();
                }
            }
            return result;
        }

        @Override
        public char[] copyToArray() {
            return this.toArray();
        }

        @Override
        public CharVector getDirect() {
            return new CharVectorDirect(this.toArray());
        }

        public final String toString() {
            return CharVector.toString(this, 10);
        }

        public final boolean equals(Object obj) {
            return CharVector.equals(this, obj);
        }

        public final int hashCode() {
            return CharVector.hashCode(this);
        }

        protected final Object writeReplace() {
            return this.getDirect();
        }
    }
}

