/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfChar;
import io.deephaven.util.annotations.ArrayType;
import io.deephaven.util.annotations.ArrayTypeGetter;
import io.deephaven.vector.CharSubVector;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.CharVectorSlice;
import java.util.Arrays;

@ArrayType(type=char[].class)
public final class CharVectorDirect
implements CharVector {
    private static final long serialVersionUID = 3636374971797603565L;
    public static final CharVector ZERO_LENGTH_VECTOR = new CharVectorDirect(new char[0]);
    private final char[] data;

    public CharVectorDirect(char ... data) {
        this.data = (char[])Require.neqNull((Object)data, (String)"data");
    }

    @Override
    public char get(long index) {
        if (index < 0L || index >= (long)this.data.length) {
            return '\uffff';
        }
        return this.data[(int)index];
    }

    @Override
    public CharVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return new CharVectorSlice(this, fromIndexInclusive, toIndexExclusive - fromIndexInclusive);
    }

    @Override
    public CharVector subVectorByPositions(long[] positions) {
        return new CharSubVector(this, positions);
    }

    @Override
    @ArrayTypeGetter
    public char[] toArray() {
        return this.data;
    }

    @Override
    public char[] copyToArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public CloseablePrimitiveIteratorOfChar iterator(long fromIndexInclusive, long toIndexExclusive) {
        if (fromIndexInclusive == 0L && toIndexExclusive == (long)this.data.length) {
            return CloseablePrimitiveIteratorOfChar.of((char[])this.data);
        }
        return CharVector.super.iterator(fromIndexInclusive, toIndexExclusive);
    }

    public long size() {
        return this.data.length;
    }

    @Override
    public CharVectorDirect getDirect() {
        return this;
    }

    public String toString() {
        return CharVector.toString(this, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharVectorDirect) {
            return Arrays.equals(this.data, ((CharVectorDirect)obj).data);
        }
        return CharVector.equals(this, obj);
    }

    public int hashCode() {
        return CharVector.hashCode(this);
    }
}

