/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.qst.type.DoubleType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.PrimitiveVectorType;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.vector.DoubleVectorDirect;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DoubleVector
extends Vector<DoubleVector>,
Iterable<Double> {
    public static final long serialVersionUID = -1373264425081841175L;

    public static PrimitiveVectorType<DoubleVector, Double> type() {
        return PrimitiveVectorType.of(DoubleVector.class, (PrimitiveType)DoubleType.of());
    }

    public double get(long var1);

    @Override
    public DoubleVector subVector(long var1, long var3);

    @Override
    public DoubleVector subVectorByPositions(long[] var1);

    public double[] toArray();

    public double[] copyToArray();

    @Override
    public DoubleVector getDirect();

    @FinalDefault
    default public CloseablePrimitiveIteratorOfDouble iterator() {
        return this.iterator(0L, this.size());
    }

    default public CloseablePrimitiveIteratorOfDouble iterator(final long fromIndexInclusive, final long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        return new CloseablePrimitiveIteratorOfDouble(){
            long nextIndex;
            {
                this.nextIndex = fromIndexInclusive;
            }

            public double nextDouble() {
                return DoubleVector.this.get(this.nextIndex++);
            }

            public boolean hasNext() {
                return this.nextIndex < toIndexExclusive;
            }
        };
    }

    @Override
    @FinalDefault
    default public Class<?> getComponentType() {
        return Double.TYPE;
    }

    @Override
    @FinalDefault
    default public String toString(int prefixLength) {
        return DoubleVector.toString(this, prefixLength);
    }

    public static String doubleValToString(Object val) {
        return val == null ? " " : DoubleVector.primitiveDoubleValToString((Double)val);
    }

    public static String primitiveDoubleValToString(double val) {
        return val == -1.7976931348623157E308 ? " " : Double.toString(val);
    }

    public static String toString(@NotNull DoubleVector vector, int prefixLength) {
        if (vector.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        int displaySize = (int)Math.min(vector.size(), (long)prefixLength);
        try (CloseablePrimitiveIteratorOfDouble iterator = vector.iterator(0L, displaySize);){
            builder.append(DoubleVector.primitiveDoubleValToString(iterator.nextDouble()));
            iterator.forEachRemaining(value -> builder.append(',').append(DoubleVector.primitiveDoubleValToString(value)));
        }
        if ((long)displaySize == vector.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }

    public static boolean equals(@NotNull DoubleVector aVector, @Nullable Object bObj) {
        if (aVector == bObj) {
            return true;
        }
        if (!(bObj instanceof DoubleVector)) {
            return false;
        }
        DoubleVector bVector = (DoubleVector)bObj;
        long size = aVector.size();
        if (size != bVector.size()) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        try (CloseablePrimitiveIteratorOfDouble aIterator = aVector.iterator();
             CloseablePrimitiveIteratorOfDouble bIterator = bVector.iterator();){
            while (aIterator.hasNext()) {
                if (Double.doubleToLongBits(aIterator.nextDouble()) == Double.doubleToLongBits(bIterator.nextDouble())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static int hashCode(@NotNull DoubleVector vector) {
        int result = 1;
        if (vector.isEmpty()) {
            return result;
        }
        try (CloseablePrimitiveIteratorOfDouble iterator = vector.iterator();){
            while (iterator.hasNext()) {
                result = 31 * result + Double.hashCode(iterator.nextDouble());
            }
        }
        return result;
    }

    public static abstract class Indirect
    implements DoubleVector {
        @Override
        public double[] toArray() {
            int size = this.intSize("DoubleVector.toArray");
            double[] result = new double[size];
            try (CloseablePrimitiveIteratorOfDouble iterator = this.iterator();){
                for (int ei = 0; ei < size; ++ei) {
                    result[ei] = iterator.nextDouble();
                }
            }
            return result;
        }

        @Override
        public double[] copyToArray() {
            return this.toArray();
        }

        @Override
        public DoubleVector getDirect() {
            return new DoubleVectorDirect(this.toArray());
        }

        public final String toString() {
            return DoubleVector.toString(this, 10);
        }

        public final boolean equals(Object obj) {
            return DoubleVector.equals(this, obj);
        }

        public final int hashCode() {
            return DoubleVector.hashCode(this);
        }

        protected final Object writeReplace() {
            return this.getDirect();
        }
    }
}

