/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.util.annotations.ArrayType;
import io.deephaven.util.annotations.ArrayTypeGetter;
import io.deephaven.vector.DoubleSubVector;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.DoubleVectorSlice;
import java.util.Arrays;

@ArrayType(type=double[].class)
public final class DoubleVectorDirect
implements DoubleVector {
    private static final long serialVersionUID = 3636374971797603565L;
    public static final DoubleVector ZERO_LENGTH_VECTOR = new DoubleVectorDirect(new double[0]);
    private final double[] data;

    public DoubleVectorDirect(double ... data) {
        this.data = (double[])Require.neqNull((Object)data, (String)"data");
    }

    @Override
    public double get(long index) {
        if (index < 0L || index >= (long)this.data.length) {
            return -1.7976931348623157E308;
        }
        return this.data[(int)index];
    }

    @Override
    public DoubleVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return new DoubleVectorSlice(this, fromIndexInclusive, toIndexExclusive - fromIndexInclusive);
    }

    @Override
    public DoubleVector subVectorByPositions(long[] positions) {
        return new DoubleSubVector(this, positions);
    }

    @Override
    @ArrayTypeGetter
    public double[] toArray() {
        return this.data;
    }

    @Override
    public double[] copyToArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public CloseablePrimitiveIteratorOfDouble iterator(long fromIndexInclusive, long toIndexExclusive) {
        if (fromIndexInclusive == 0L && toIndexExclusive == (long)this.data.length) {
            return CloseablePrimitiveIteratorOfDouble.of((double[])this.data);
        }
        return DoubleVector.super.iterator(fromIndexInclusive, toIndexExclusive);
    }

    public long size() {
        return this.data.length;
    }

    @Override
    public DoubleVectorDirect getDirect() {
        return this;
    }

    public String toString() {
        return DoubleVector.toString(this, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleVectorDirect) {
            return Arrays.equals(this.data, ((DoubleVectorDirect)obj).data);
        }
        return DoubleVector.equals(this, obj);
    }

    public int hashCode() {
        return DoubleVector.hashCode(this);
    }
}

