/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.vector.FloatVector;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public final class FloatSubVector
extends FloatVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final FloatVector innerVector;
    private final long[] positions;

    public FloatSubVector(@NotNull FloatVector innerVector, @NotNull long[] positions) {
        this.innerVector = innerVector;
        this.positions = positions;
    }

    @Override
    public float get(long index) {
        if (index < 0L || index >= (long)this.positions.length) {
            return -3.4028235E38f;
        }
        return this.innerVector.get(this.positions[(int)index]);
    }

    @Override
    public FloatVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositionRange(this.positions, fromIndexInclusive, toIndexExclusive));
    }

    @Override
    public FloatVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositions(this.positions, positions));
    }

    public long size() {
        return this.positions.length;
    }
}

