/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.qst.type.IntType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.PrimitiveVectorType;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.vector.IntVectorDirect;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IntVector
extends Vector<IntVector>,
Iterable<Integer> {
    public static final long serialVersionUID = -1373264425081841175L;

    public static PrimitiveVectorType<IntVector, Integer> type() {
        return PrimitiveVectorType.of(IntVector.class, (PrimitiveType)IntType.of());
    }

    public int get(long var1);

    @Override
    public IntVector subVector(long var1, long var3);

    @Override
    public IntVector subVectorByPositions(long[] var1);

    public int[] toArray();

    public int[] copyToArray();

    @Override
    public IntVector getDirect();

    @FinalDefault
    default public CloseablePrimitiveIteratorOfInt iterator() {
        return this.iterator(0L, this.size());
    }

    default public CloseablePrimitiveIteratorOfInt iterator(final long fromIndexInclusive, final long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        return new CloseablePrimitiveIteratorOfInt(){
            long nextIndex;
            {
                this.nextIndex = fromIndexInclusive;
            }

            public int nextInt() {
                return IntVector.this.get(this.nextIndex++);
            }

            public boolean hasNext() {
                return this.nextIndex < toIndexExclusive;
            }
        };
    }

    @Override
    @FinalDefault
    default public Class<?> getComponentType() {
        return Integer.TYPE;
    }

    @Override
    @FinalDefault
    default public String toString(int prefixLength) {
        return IntVector.toString(this, prefixLength);
    }

    public static String intValToString(Object val) {
        return val == null ? " " : IntVector.primitiveIntValToString((Integer)val);
    }

    public static String primitiveIntValToString(int val) {
        return val == Integer.MIN_VALUE ? " " : Integer.toString(val);
    }

    public static String toString(@NotNull IntVector vector, int prefixLength) {
        if (vector.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        int displaySize = (int)Math.min(vector.size(), (long)prefixLength);
        try (CloseablePrimitiveIteratorOfInt iterator = vector.iterator(0L, displaySize);){
            builder.append(IntVector.primitiveIntValToString(iterator.nextInt()));
            iterator.forEachRemaining(value -> builder.append(',').append(IntVector.primitiveIntValToString(value)));
        }
        if ((long)displaySize == vector.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }

    public static boolean equals(@NotNull IntVector aVector, @Nullable Object bObj) {
        if (aVector == bObj) {
            return true;
        }
        if (!(bObj instanceof IntVector)) {
            return false;
        }
        IntVector bVector = (IntVector)bObj;
        long size = aVector.size();
        if (size != bVector.size()) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        try (CloseablePrimitiveIteratorOfInt aIterator = aVector.iterator();
             CloseablePrimitiveIteratorOfInt bIterator = bVector.iterator();){
            while (aIterator.hasNext()) {
                if (aIterator.nextInt() == bIterator.nextInt()) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static int hashCode(@NotNull IntVector vector) {
        int result = 1;
        if (vector.isEmpty()) {
            return result;
        }
        try (CloseablePrimitiveIteratorOfInt iterator = vector.iterator();){
            while (iterator.hasNext()) {
                result = 31 * result + Integer.hashCode(iterator.nextInt());
            }
        }
        return result;
    }

    public static abstract class Indirect
    implements IntVector {
        @Override
        public int[] toArray() {
            int size = this.intSize("IntVector.toArray");
            int[] result = new int[size];
            try (CloseablePrimitiveIteratorOfInt iterator = this.iterator();){
                for (int ei = 0; ei < size; ++ei) {
                    result[ei] = iterator.nextInt();
                }
            }
            return result;
        }

        @Override
        public int[] copyToArray() {
            return this.toArray();
        }

        @Override
        public IntVector getDirect() {
            return new IntVectorDirect(this.toArray());
        }

        public final String toString() {
            return IntVector.toString(this, 10);
        }

        public final boolean equals(Object obj) {
            return IntVector.equals(this, obj);
        }

        public final int hashCode() {
            return IntVector.hashCode(this);
        }

        protected final Object writeReplace() {
            return this.getDirect();
        }
    }
}

