/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.GenericVectorType;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.ObjectVectorDirect;
import io.deephaven.vector.Vector;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ObjectVector<COMPONENT_TYPE>
extends Vector<ObjectVector<COMPONENT_TYPE>>,
Iterable<COMPONENT_TYPE> {
    public static final long serialVersionUID = 2691131699080413017L;

    public static <T> GenericVectorType<ObjectVector<T>, T> type(GenericType<T> genericType) {
        return GenericVectorType.of(ObjectVector.class, genericType);
    }

    public COMPONENT_TYPE get(long var1);

    @Override
    public ObjectVector<COMPONENT_TYPE> subVector(long var1, long var3);

    @Override
    public ObjectVector<COMPONENT_TYPE> subVectorByPositions(long[] var1);

    public COMPONENT_TYPE[] toArray();

    public COMPONENT_TYPE[] copyToArray();

    @Override
    public ObjectVector<COMPONENT_TYPE> getDirect();

    @Override
    public Class<COMPONENT_TYPE> getComponentType();

    @Override
    @FinalDefault
    default public CloseableIterator<COMPONENT_TYPE> iterator() {
        return this.iterator(0L, this.size());
    }

    default public CloseableIterator<COMPONENT_TYPE> iterator(final long fromIndexInclusive, final long toIndexExclusive) {
        Require.leq((long)fromIndexInclusive, (String)"fromIndexInclusive", (long)toIndexExclusive, (String)"toIndexExclusive");
        return new CloseableIterator<COMPONENT_TYPE>(){
            long nextIndex;
            {
                this.nextIndex = fromIndexInclusive;
            }

            public COMPONENT_TYPE next() {
                return ObjectVector.this.get(this.nextIndex++);
            }

            public boolean hasNext() {
                return this.nextIndex < toIndexExclusive;
            }
        };
    }

    @Override
    @FinalDefault
    default public String toString(int prefixLength) {
        return ObjectVector.toString(this, prefixLength);
    }

    public static String defaultValToString(Object val) {
        return val == null ? " " : val.toString();
    }

    public static String toString(@NotNull ObjectVector<?> vector, int prefixLength) {
        if (vector.isEmpty()) {
            return "[]";
        }
        Function<Object, String> valToString = Vector.classToHelper(vector.getComponentType());
        StringBuilder builder = new StringBuilder("[");
        int displaySize = (int)Math.min(vector.size(), (long)prefixLength);
        try (CloseableIterator<?> iterator = vector.iterator(0L, displaySize);){
            builder.append(valToString.apply(iterator.next()));
            iterator.forEachRemaining(value -> builder.append(',').append((String)valToString.apply(value)));
        }
        if ((long)displaySize == vector.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }

    public static boolean equals(@NotNull ObjectVector<?> aVector, @Nullable Object bObj) {
        if (aVector == bObj) {
            return true;
        }
        if (!(bObj instanceof ObjectVector)) {
            return false;
        }
        ObjectVector bVector = (ObjectVector)bObj;
        long size = aVector.size();
        if (size != bVector.size()) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        try (CloseableIterator<?> aIterator = aVector.iterator();
             CloseableIterator bIterator = bVector.iterator();){
            while (aIterator.hasNext()) {
                if (Objects.equals(aIterator.next(), bIterator.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static int hashCode(@NotNull ObjectVector<?> vector) {
        int result = 1;
        if (vector.isEmpty()) {
            return result;
        }
        try (CloseableIterator<?> iterator = vector.iterator();){
            while (iterator.hasNext()) {
                result = 31 * result + Objects.hashCode(iterator.next());
            }
        }
        return result;
    }

    public static abstract class Indirect<COMPONENT_TYPE>
    implements ObjectVector<COMPONENT_TYPE> {
        @Override
        public COMPONENT_TYPE[] toArray() {
            int size = this.intSize("ObjectVector.toArray");
            Object[] result = (Object[])Array.newInstance(this.getComponentType(), size);
            try (CloseableIterator iterator = this.iterator();){
                for (int ei = 0; ei < size; ++ei) {
                    result[ei] = iterator.next();
                }
            }
            return result;
        }

        @Override
        public COMPONENT_TYPE[] copyToArray() {
            return this.toArray();
        }

        @Override
        public ObjectVector<COMPONENT_TYPE> getDirect() {
            if (Vector.class.isAssignableFrom(this.getComponentType())) {
                int size = LongSizedDataStructure.intSize((String)"ObjectVector.Indirect.getDirect", (long)this.size());
                Object[] array = (Object[])Array.newInstance(this.getComponentType(), size);
                try (CloseableIterator iterator = this.iterator();){
                    for (int ei = 0; ei < size; ++ei) {
                        Object element = iterator.next();
                        array[ei] = element == null ? null : ((Vector)element).getDirect();
                    }
                }
                return new ObjectVectorDirect<Object>(array);
            }
            return new ObjectVectorDirect<COMPONENT_TYPE>(this.toArray());
        }

        public final String toString() {
            return ObjectVector.toString(this, 10);
        }

        public final boolean equals(Object obj) {
            return ObjectVector.equals(this, obj);
        }

        public final int hashCode() {
            return ObjectVector.hashCode(this);
        }

        protected final Object writeReplace() {
            return new ObjectVectorDirect<COMPONENT_TYPE>(this.toArray());
        }
    }
}

