/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.vector.ObjectSubVector;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorSlice;
import java.util.Arrays;

public final class ObjectVectorDirect<COMPONENT_TYPE>
implements ObjectVector<COMPONENT_TYPE> {
    private static final long serialVersionUID = 9111886364211462917L;
    public static final ObjectVector<?> ZERO_LENGTH_VECTOR = new ObjectVectorDirect<Object>(new Object[0]);
    private final COMPONENT_TYPE[] data;
    private final Class<COMPONENT_TYPE> componentType;

    public static <COMPONENT_TYPE> ObjectVector<COMPONENT_TYPE> empty() {
        return ZERO_LENGTH_VECTOR;
    }

    public ObjectVectorDirect(COMPONENT_TYPE ... data) {
        this.data = (Object[])Require.neqNull(data, (String)"data");
        this.componentType = data.getClass().getComponentType();
    }

    @Override
    public COMPONENT_TYPE get(long index) {
        if (index < 0L || index >= (long)this.data.length) {
            return null;
        }
        return this.data[(int)index];
    }

    @Override
    public ObjectVector<COMPONENT_TYPE> subVector(long fromIndexInclusive, long toIndexExclusive) {
        return new ObjectVectorSlice(this, fromIndexInclusive, toIndexExclusive - fromIndexInclusive);
    }

    @Override
    public ObjectVector<COMPONENT_TYPE> subVectorByPositions(long[] positions) {
        return new ObjectSubVector(this, positions);
    }

    @Override
    public COMPONENT_TYPE[] toArray() {
        return this.data;
    }

    @Override
    public COMPONENT_TYPE[] copyToArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public CloseableIterator<COMPONENT_TYPE> iterator(long fromIndexInclusive, long toIndexExclusive) {
        if (fromIndexInclusive == 0L && toIndexExclusive == (long)this.data.length) {
            return CloseableIterator.of((Object[])this.data);
        }
        return ObjectVector.super.iterator(fromIndexInclusive, toIndexExclusive);
    }

    public long size() {
        return this.data.length;
    }

    @Override
    public Class<COMPONENT_TYPE> getComponentType() {
        return this.componentType;
    }

    @Override
    public ObjectVectorDirect<COMPONENT_TYPE> getDirect() {
        return this;
    }

    public String toString() {
        return ObjectVector.toString(this, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectVectorDirect) {
            return Arrays.equals(this.data, ((ObjectVectorDirect)obj).data);
        }
        return ObjectVector.equals(this, obj);
    }

    public int hashCode() {
        return ObjectVector.hashCode(this);
    }
}

