/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.vector.ShortVector;
import io.deephaven.vector.Vector;
import org.jetbrains.annotations.NotNull;

public final class ShortSubVector
extends ShortVector.Indirect {
    private static final long serialVersionUID = 1L;
    private final ShortVector innerVector;
    private final long[] positions;

    public ShortSubVector(@NotNull ShortVector innerVector, @NotNull long[] positions) {
        this.innerVector = innerVector;
        this.positions = positions;
    }

    @Override
    public short get(long index) {
        if (index < 0L || index >= (long)this.positions.length) {
            return Short.MIN_VALUE;
        }
        return this.innerVector.get(this.positions[(int)index]);
    }

    @Override
    public ShortVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositionRange(this.positions, fromIndexInclusive, toIndexExclusive));
    }

    @Override
    public ShortVector subVectorByPositions(long[] positions) {
        return this.innerVector.subVectorByPositions(Vector.mapSelectedPositions(this.positions, positions));
    }

    public long size() {
        return this.positions.length;
    }
}

