/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.vector;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfShort;
import io.deephaven.util.annotations.ArrayType;
import io.deephaven.util.annotations.ArrayTypeGetter;
import io.deephaven.vector.ShortSubVector;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.ShortVectorSlice;
import java.util.Arrays;

@ArrayType(type=short[].class)
public final class ShortVectorDirect
implements ShortVector {
    private static final long serialVersionUID = 3636374971797603565L;
    public static final ShortVector ZERO_LENGTH_VECTOR = new ShortVectorDirect(new short[0]);
    private final short[] data;

    public ShortVectorDirect(short ... data) {
        this.data = (short[])Require.neqNull((Object)data, (String)"data");
    }

    @Override
    public short get(long index) {
        if (index < 0L || index >= (long)this.data.length) {
            return Short.MIN_VALUE;
        }
        return this.data[(int)index];
    }

    @Override
    public ShortVector subVector(long fromIndexInclusive, long toIndexExclusive) {
        return new ShortVectorSlice(this, fromIndexInclusive, toIndexExclusive - fromIndexInclusive);
    }

    @Override
    public ShortVector subVectorByPositions(long[] positions) {
        return new ShortSubVector(this, positions);
    }

    @Override
    @ArrayTypeGetter
    public short[] toArray() {
        return this.data;
    }

    @Override
    public short[] copyToArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public CloseablePrimitiveIteratorOfShort iterator(long fromIndexInclusive, long toIndexExclusive) {
        if (fromIndexInclusive == 0L && toIndexExclusive == (long)this.data.length) {
            return CloseablePrimitiveIteratorOfShort.of((short[])this.data);
        }
        return ShortVector.super.iterator(fromIndexInclusive, toIndexExclusive);
    }

    public long size() {
        return this.data.length;
    }

    @Override
    public ShortVectorDirect getDirect() {
        return this;
    }

    public String toString() {
        return ShortVector.toString(this, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShortVectorDirect) {
            return Arrays.equals(this.data, ((ShortVectorDirect)obj).data);
        }
        return ShortVector.equals(this, obj);
    }

    public int hashCode() {
        return ShortVector.hashCode(this);
    }
}

